/*
 * Decompiled with CFR 0.152.
 */
package no.acando.xmltordf;

import java.util.HashMap;
import java.util.Map;
import no.acando.xmltordf.ComplexClassTransform;
import no.acando.xmltordf.CompositeId;
import no.acando.xmltordf.Element;
import no.acando.xmltordf.ReverseElementTree;
import no.acando.xmltordf.SimpleTypePolicy;
import no.acando.xmltordf.StringTransform;
import no.acando.xmltordf.StringTransformTwoValue;
import no.acando.xmltordf.XmlToRdfAdvancedJena;
import no.acando.xmltordf.XmlToRdfAdvancedSesame;
import no.acando.xmltordf.XmlToRdfAdvancedStream;
import no.acando.xmltordf.XmlToRdfFast;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.openrdf.model.IRI;

public class Builder {
    public static XmlPath createPath(String ... path) {
        XmlPath xmlPath = new XmlPath(path);
        return xmlPath;
    }

    public static AdvancedJena getAdvancedBuilderJena() {
        return new AdvancedJena();
    }

    public static AdvancedSesame getAdvancedBuilderSesame() {
        return new AdvancedSesame();
    }

    public static AdvancedStream getAdvancedBuilderStream() {
        return new AdvancedStream();
    }

    public static Fast getFastBuilder() {
        return new Fast();
    }

    private static String nullValueCheck(String value) {
        if (value == null) {
            value = "";
        }
        return value;
    }

    private static class HashMapNoOverwriteWithDefault<Key, Value>
    extends HashMapNoOverwrite<Key, Value> {
        Value defaultValue;

        private HashMapNoOverwriteWithDefault() {
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                return this.defaultValue != null;
            }
            return super.containsKey(key);
        }

        @Override
        public Value get(Object key) {
            if (key == null) {
                return this.defaultValue;
            }
            Object value = super.get(key);
            return (Value)(value != null ? value : this.defaultValue);
        }

        @Override
        public Value put(Key key, Value value) {
            if (key == null) {
                if (this.defaultValue != null) {
                    throw new RuntimeException("Attempted to overwrite defaultValue with value: '" + value.toString() + "'");
                }
                this.defaultValue = value;
                return this.defaultValue;
            }
            return super.put(key, value);
        }

        public Value getWithoutDefault(Key key1) {
            if (key1 == null) {
                return this.defaultValue;
            }
            return (Value)super.get(key1);
        }
    }

    private static class HashMapNoOverwriteWithDefaultTwoLevels<Key1, Key2, Value> {
        HashMapNoOverwriteWithDefault<Key1, HashMapNoOverwriteWithDefault<Key2, Value>> internalMap = new HashMapNoOverwriteWithDefault();

        private HashMapNoOverwriteWithDefaultTwoLevels() {
        }

        Value get(Key1 key1, Key2 key2) {
            HashMapNoOverwriteWithDefault<Key2, Value> firstLevel = this.internalMap.get(key1);
            if (firstLevel != null) {
                Value value = firstLevel.get(key2);
                if (value == null && this.internalMap.defaultValue != null) {
                    return ((HashMapNoOverwriteWithDefault)this.internalMap.defaultValue).get(key2);
                }
                return value;
            }
            return null;
        }

        void put(Key1 key1, Key2 key2, Value value) {
            HashMapNoOverwriteWithDefault<Object, Value> firstLevel = this.internalMap.getWithoutDefault(key1);
            if (firstLevel == null) {
                firstLevel = new HashMapNoOverwriteWithDefault();
                this.internalMap.put(key1, firstLevel);
            }
            firstLevel.put(key2, value);
        }

        boolean containsKey(Key1 key1, Key2 key2) {
            return this.get(key1, key2) != null;
        }
    }

    private static class HashMapNoOverwrite<Key, Value>
    extends HashMap<Key, Value> {
        private HashMapNoOverwrite() {
        }

        @Override
        public Value put(Key key, Value value) {
            if (this.containsKey(key)) {
                throw new RuntimeException("Attempted to overwrite key: '" + key.toString() + "' with value: '" + value.toString() + "'");
            }
            return super.put(key, value);
        }
    }

    public static class AdvancedStream
    extends Advanced<String, String, AdvancedStream> {
        public XmlToRdfAdvancedStream build() {
            return new XmlToRdfAdvancedStream(this);
        }
    }

    public static class AdvancedSesame
    extends AdvancedWithBuffer<IRI, IRI, AdvancedSesame> {
        public XmlToRdfAdvancedSesame build() {
            return new XmlToRdfAdvancedSesame(this);
        }
    }

    public static class AdvancedJena
    extends AdvancedWithBuffer<Node, RDFDatatype, AdvancedJena> {
        public XmlToRdfAdvancedJena build() {
            return new XmlToRdfAdvancedJena(this);
        }
    }

    public static class AdvancedWithBuffer<ResourceType, Datatype, T extends AdvancedWithBuffer<ResourceType, Datatype, T>>
    extends Advanced<ResourceType, Datatype, T> {
        int buffer = 1000;

        public T setBuffer(int size) {
            this.buffer = size;
            return (T)this;
        }
    }

    public static class Advanced<ResourceType, DataType, T extends Advanced<ResourceType, DataType, T>>
    extends DefaultWithAddIndex<T> {
        boolean convertComplexElementsWithOnlyAttributesToPredicates;
        String baseNamespace;
        AppliesTo baseNamespaceAppliesTo;
        boolean autoAttributeNamespace = true;
        boolean convertComplexElementsWithOnlyAttributesAndSimpleTypeChildrenToPredicate;
        boolean autoTypeLiterals;
        boolean uuidBasedIdInsteadOfBlankNodes;
        private Map<String, ParentChild> invertPredicate = null;
        private HashMapNoOverwriteWithDefaultTwoLevels<String, String, String> insertPredicateBetween = null;
        Map<String, DataType> dataTypeOnElement = null;
        Map<String, Map<String, ResourceType>> literalMap = null;
        private HashMapNoOverwriteWithDefaultTwoLevels<String, String, HashMapNoOverwrite<String, ResourceType>> elementAttributeTextToUriMap = null;
        boolean resolveAsQnameInAttributeValue;
        boolean xsiTypeSupport;
        private Map<String, ComplexClassTransform> complexElementTransformAtEndOfElement = null;
        private Map<String, ComplexClassTransform> complexElementTransformAtStartOfElement = null;
        Map<String, String> useElementAsPredicateMap = null;
        Map<String, String> skipElementMap = null;
        Map<String, String> forcedMixedContentMap = null;
        Map<String, CompositeId<T>> compositeIdMap;

        public T mapTextInElementToUri(String elementName, String from, ResourceType to) {
            if (this.literalMap == null) {
                this.literalMap = new HashMapNoOverwriteWithDefault<String, Map<String, ResourceType>>();
            }
            if (!this.literalMap.containsKey(elementName)) {
                this.literalMap.put(elementName, new HashMapNoOverwriteWithDefault());
            }
            this.literalMap.get(elementName).put(from, to);
            return (T)this;
        }

        public T mapTextInAttributeToUri(String elementName, String attributeName, String from, ResourceType to) {
            if (this.elementAttributeTextToUriMap == null) {
                this.elementAttributeTextToUriMap = new HashMapNoOverwriteWithDefaultTwoLevels();
            }
            if (!this.elementAttributeTextToUriMap.containsKey(elementName, attributeName)) {
                this.elementAttributeTextToUriMap.put(elementName, attributeName, new HashMapNoOverwrite());
            }
            this.elementAttributeTextToUriMap.get(elementName, attributeName).put(from, to);
            return (T)this;
        }

        ResourceType getUriForTextInAttribute(String elementName, String attributeName, String text) {
            if (this.elementAttributeTextToUriMap == null) {
                return null;
            }
            HashMapNoOverwrite<String, ResourceType> innerMap = this.elementAttributeTextToUriMap.get(elementName, attributeName);
            return innerMap != null ? (ResourceType)innerMap.get(text) : null;
        }

        public T convertComplexElementsWithOnlyAttributesToPredicate(boolean enabled) {
            this.convertComplexElementsWithOnlyAttributesToPredicates = enabled;
            return (T)this;
        }

        public T autoAttributeNamespace(boolean enabled) {
            this.autoAttributeNamespace = enabled;
            return (T)this;
        }

        public T setBaseNamespace(String namespace, AppliesTo which) {
            this.baseNamespace = namespace;
            this.baseNamespaceAppliesTo = which;
            return (T)this;
        }

        public T convertComplexElementsWithOnlyAttributesAndSimpleTypeChildrenToPredicate(boolean enabled) {
            this.convertComplexElementsWithOnlyAttributesAndSimpleTypeChildrenToPredicate = enabled;
            return (T)this;
        }

        public T autoTypeLiterals(boolean enabled) {
            this.autoTypeLiterals = enabled;
            return (T)this;
        }

        public BetweenWithWildcard<T> insertPredicate(final String predicate) {
            if (this.insertPredicateBetween == null) {
                this.insertPredicateBetween = new HashMapNoOverwriteWithDefaultTwoLevels();
            }
            final Advanced that = this;
            return new BetweenWithWildcard<T>(){

                @Override
                public T between(String parent, String child) {
                    if (parent == null || child == null) {
                        throw new IllegalArgumentException("parent or child can not be null, use betweenAny() or betweenAnyParentAndSpecificChild(child) or betweenSpecificParentAndAnyChild(parent)");
                    }
                    insertPredicateBetween.put(parent, child, predicate);
                    return that;
                }

                @Override
                public T betweenAny() {
                    insertPredicateBetween.put(null, null, predicate);
                    return that;
                }

                @Override
                public T betweenAnyParentAndSpecificChild(String child) {
                    if (child == null) {
                        throw new IllegalArgumentException("child can not be null, use betweenAny()");
                    }
                    insertPredicateBetween.put(null, child, predicate);
                    return that;
                }

                @Override
                public T betweenSpecificParentAndAnyChild(String parent) {
                    if (parent == null) {
                        throw new IllegalArgumentException("parent can not be null, use betweenAny()");
                    }
                    insertPredicateBetween.put(parent, null, predicate);
                    return that;
                }
            };
        }

        String getInsertPredicateBetweenOrDefaultPredicate(String parent, String child, String defaultPredicate) {
            if (this.insertPredicateBetween == null) {
                return defaultPredicate;
            }
            String s = this.insertPredicateBetween.get(parent, child);
            return s != null ? s : defaultPredicate;
        }

        public BetweenWithWildcard<T> invertPredicate(final String predicate) {
            if (this.invertPredicate == null) {
                this.invertPredicate = new HashMapNoOverwrite<String, ParentChild>();
            }
            final Advanced that = this;
            return new BetweenWithWildcard<T>(){

                @Override
                public T between(String parent, String child) {
                    if (parent == null || child == null) {
                        throw new IllegalArgumentException("parent or child can not be null, use betweenAny() or betweenAnyParentAndSpecificChild(child) or betweenSpecificParentAndAnyChild(parent)");
                    }
                    invertPredicate.put(predicate, new ParentChild(parent, child));
                    return that;
                }

                @Override
                public T betweenAny() {
                    invertPredicate.put(predicate, new ParentChild(null, null));
                    return that;
                }

                @Override
                public T betweenAnyParentAndSpecificChild(String child) {
                    if (child == null) {
                        throw new IllegalArgumentException("child can not be null, use betweenAny()");
                    }
                    invertPredicate.put(predicate, new ParentChild(null, child));
                    return that;
                }

                @Override
                public T betweenSpecificParentAndAnyChild(String parent) {
                    if (parent == null) {
                        throw new IllegalArgumentException("parent can not be null, use betweenAny()");
                    }
                    invertPredicate.put(predicate, new ParentChild(parent, null));
                    return that;
                }
            };
        }

        public T skipElement(String elementName) {
            if (this.skipElementMap == null) {
                this.skipElementMap = new HashMap<String, String>();
            }
            this.skipElementMap.put(elementName, elementName);
            return (T)this;
        }

        public T useElementAsPredicate(String elementName) {
            if (this.useElementAsPredicateMap == null) {
                this.useElementAsPredicateMap = new HashMap<String, String>();
            }
            this.useElementAsPredicateMap.put(elementName, elementName);
            return (T)this;
        }

        public T forceMixedContent(String elementName) {
            if (this.forcedMixedContentMap == null) {
                this.forcedMixedContentMap = new HashMap<String, String>();
            }
            this.forcedMixedContentMap.put(elementName, elementName);
            return (T)this;
        }

        public CompositeId<T> compositeId(String elementName) {
            if (this.compositeIdMap == null) {
                this.compositeIdMap = new HashMapNoOverwrite<String, CompositeId<T>>();
            }
            return new CompositeId<Advanced>(this, elementName, this.compositeIdMap);
        }

        boolean checkInvertPredicate(String predicate, String parent, String child) {
            if (this.invertPredicate == null) {
                return false;
            }
            ParentChild parentChild = this.invertPredicate.get(predicate);
            if (parentChild != null) {
                return parentChild.correctParentChild(parent, child);
            }
            return false;
        }

        public T uuidBasedIdInsteadOfBlankNodes(boolean enabled) {
            this.uuidBasedIdInsteadOfBlankNodes = enabled;
            return (T)this;
        }

        public T setDatatype(String element, DataType datatype) {
            if (this.dataTypeOnElement == null) {
                this.dataTypeOnElement = new HashMapNoOverwrite<String, DataType>();
            }
            this.dataTypeOnElement.put(element, datatype);
            return (T)this;
        }

        public T addComplexElementTransformAtEndOfElement(String element, ComplexClassTransform transform) {
            if (this.complexElementTransformAtEndOfElement == null) {
                this.complexElementTransformAtEndOfElement = new HashMapNoOverwrite<String, ComplexClassTransform>();
            }
            this.complexElementTransformAtEndOfElement.put(element, transform);
            return (T)this;
        }

        void doComplexTransformElementAtEndOfElement(Element element) {
            if (this.complexElementTransformAtEndOfElement == null) {
                return;
            }
            ComplexClassTransform complexClassTransform = this.complexElementTransformAtEndOfElement.get(element.type);
            if (complexClassTransform != null) {
                complexClassTransform.transform(element);
            }
        }

        public T addComplexElementTransformAtStartOfElement(String element, ComplexClassTransform transform) {
            if (this.complexElementTransformAtStartOfElement == null) {
                this.complexElementTransformAtStartOfElement = new HashMapNoOverwrite<String, ComplexClassTransform>();
            }
            this.complexElementTransformAtStartOfElement.put(element, transform);
            return (T)this;
        }

        void doComplexTransformElementAtStartOfElement(Element element) {
            if (this.complexElementTransformAtStartOfElement == null) {
                return;
            }
            ComplexClassTransform complexClassTransform = this.complexElementTransformAtStartOfElement.get(element.type);
            if (complexClassTransform != null) {
                complexClassTransform.transform(element);
            }
        }

        public T resolveAsQnameInAttributeValue(boolean enabled) {
            this.resolveAsQnameInAttributeValue = enabled;
            return (T)this;
        }

        public T xsiTypeSupport(boolean enabled) {
            this.xsiTypeSupport = enabled;
            return (T)this;
        }

        class ParentChild {
            String parent;
            String child;

            public ParentChild(String parent, String child) {
                this.parent = parent;
                this.child = child;
            }

            public boolean correctParentChild(String parent, String child) {
                if (this.parent != null && !this.parent.equals(parent)) {
                    return false;
                }
                return this.child == null || this.child.equals(child);
            }
        }

        public static interface BetweenWithWildcard<TT> {
            public TT between(String var1, String var2);

            public TT betweenAny();

            public TT betweenAnyParentAndSpecificChild(String var1);

            public TT betweenSpecificParentAndAnyChild(String var1);
        }
    }

    public static class Fast
    extends Default<Fast> {
        public XmlToRdfFast build() {
            return new XmlToRdfFast(this);
        }
    }

    private static class DefaultWithAddIndex<T extends DefaultWithAddIndex<T>>
    extends Default<T> {
        boolean addIndex;
        HashMapNoOverwriteWithDefaultTwoLevels<String, String, StringTransform> useAttributedForIdMap;
        String autoAddSuffixToNamespace = "#";

        private DefaultWithAddIndex() {
        }

        public T addIndex(boolean enabled) {
            this.addIndex = enabled;
            return (T)this;
        }

        public T useAttributeForId(String elementName, String attributeName, StringTransform stringTransform) {
            if (this.useAttributedForIdMap == null) {
                this.useAttributedForIdMap = new HashMapNoOverwriteWithDefaultTwoLevels();
            }
            this.useAttributedForIdMap.put(elementName, attributeName, stringTransform);
            return (T)this;
        }

        void getIdByUseAttributeForId(String type, String s, String value, Element element) {
            StringTransform stringTransform;
            if (this.useAttributedForIdMap != null && (stringTransform = this.useAttributedForIdMap.get(type, s)) != null) {
                element.uri = stringTransform.transform(value);
            }
        }

        public T autoAddSuffixToNamespace(String sign) {
            this.autoAddSuffixToNamespace = sign;
            return (T)this;
        }

        public T autoAddSuffixToNamespace(boolean enabled) {
            if (!enabled) {
                this.autoAddSuffixToNamespace = null;
            }
            return (T)this;
        }
    }

    static class Default<T extends Default<T>> {
        String overrideNamespace = null;
        Map<String, String> renameElementMap = null;
        boolean autoDetectLiteralProperties = true;
        HashMapNoOverwriteWithDefaultTwoLevels<String, String, StringTransform> transformForAttributeValueMap = null;
        Map<String, StringTransformTwoValue> renameElementFunctionMap = null;
        ReverseElementTree renameElementPathMap = null;

        Default() {
        }

        public T overrideNamespace(String namespace) {
            this.overrideNamespace = namespace;
            return (T)this;
        }

        public T renameElement(String elementFrom, String to) {
            elementFrom = elementFrom.intern();
            to = to.intern();
            if (this.renameElementMap == null) {
                this.renameElementMap = new HashMapNoOverwrite<String, String>();
            }
            this.renameElementMap.put(elementFrom, to);
            return (T)this;
        }

        public T renameElement(XmlPath path, String to) {
            if (this.renameElementPathMap == null) {
                this.renameElementPathMap = new ReverseElementTree();
            }
            this.renameElementPathMap.insert(path, to);
            return (T)this;
        }

        public T renameElement(String elementFrom, StringTransformTwoValue transform) {
            if (this.renameElementFunctionMap == null) {
                this.renameElementFunctionMap = new HashMapNoOverwriteWithDefault<String, StringTransformTwoValue>();
            }
            this.renameElementFunctionMap.put(elementFrom, transform);
            return (T)this;
        }

        public T simpleTypePolicy(SimpleTypePolicy policy) {
            this.autoDetectLiteralProperties = policy.equals((Object)SimpleTypePolicy.compact);
            return (T)this;
        }

        public T addTransformationForAttributeValue(String elementName, String attributeName, StringTransform transform) {
            if (this.transformForAttributeValueMap == null) {
                this.transformForAttributeValueMap = new HashMapNoOverwriteWithDefaultTwoLevels();
            }
            this.transformForAttributeValueMap.put(elementName, attributeName, transform);
            return (T)this;
        }

        String doTransformForAttribute(String element, String attribute, String value) {
            StringTransform stringTransform;
            if (this.transformForAttributeValueMap != null && (stringTransform = this.transformForAttributeValueMap.get(element, attribute)) != null) {
                return stringTransform.transform(value);
            }
            return value;
        }
    }

    public static enum AppliesTo {
        justAttributes,
        justElements,
        bothElementsAndAttributes;

    }

    static class XmlPath {
        String[] path;
        int lastElement;

        public XmlPath(String[] path) {
            this.path = path;
            this.lastElement = path.length - 1;
        }

        boolean equals(Element tailElemenet) {
            Element current = tailElemenet;
            for (int i = this.path.length - 1; i >= 0; --i) {
                if (current == null) {
                    return false;
                }
                if (!current.type.equals(this.path[i])) {
                    return false;
                }
                current = current.parent;
            }
            return true;
        }

        public String getTail() {
            if (this.lastElement < 0) {
                return null;
            }
            return this.path[this.lastElement];
        }

        public XmlPath shorten() {
            --this.lastElement;
            return this;
        }

        public boolean last() {
            return this.lastElement == 0;
        }
    }
}

