/*
 * Decompiled with CFR 0.152.
 */
package no.acando.xmltordf;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class CompositeId<T> {
    private Map<String, String> requiredElement = new HashMap<String, String>();
    private Map<String, String> requiredAttribute = new HashMap<String, String>();
    private Map<String, String> resolvedElement = new HashMap<String, String>();
    private Map<String, String> resolvedAttribute = new HashMap<String, String>();
    private BiFunction<Map<String, String>, Map<String, String>, String> mapFunction;
    private Map<String, CompositeId<T>> compositeIdMap;
    private String elementName;
    private T that;

    CompositeId(T that, String elementName, Map<String, CompositeId<T>> compositeIdMap) {
        this.that = that;
        this.elementName = elementName;
        this.compositeIdMap = compositeIdMap;
    }

    CompositeId(CompositeId<T> from) {
        this.requiredAttribute = from.requiredAttribute;
        this.requiredElement = from.requiredElement;
        this.that = from.that;
        this.elementName = from.elementName;
        this.compositeIdMap = from.compositeIdMap;
        this.mapFunction = from.mapFunction;
    }

    void resetMaps() {
        this.resolvedAttribute = new HashMap<String, String>();
        this.resolvedElement = new HashMap<String, String>();
    }

    public CompositeId<T> fromElement(String elementName) {
        this.requiredElement.put(elementName, elementName);
        return this;
    }

    public CompositeId<T> fromAttribute(String attributeName) {
        this.requiredAttribute.put(attributeName, attributeName);
        return this;
    }

    public T mappedTo(BiFunction<Map<String, String>, Map<String, String>, String> mapFunction) {
        this.mapFunction = mapFunction;
        this.compositeIdMap.put(this.elementName, this);
        return this.that;
    }

    boolean completed() {
        return this.resolvedElement.size() + this.resolvedAttribute.size() == this.requiredElement.size() + this.requiredAttribute.size();
    }

    void resolveElement(String elementName, String value) {
        if (this.requiredElement.containsKey(elementName)) {
            this.resolvedElement.put(elementName, value);
        }
    }

    void resolveAttribute(String attributeName, String value) {
        if (this.requiredAttribute.containsKey(attributeName)) {
            this.resolvedAttribute.put(attributeName, value);
        }
    }

    String resolveIdentifier() {
        return this.mapFunction.apply(this.resolvedElement, this.resolvedAttribute);
    }

    public CompositeId<T> simpleClone() {
        return new CompositeId<T>(this);
    }
}

