/*
 * Decompiled with CFR 0.152.
 */
package no.acando.xmltordf;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import no.acando.xmltordf.AdvancedSaxHandler;
import no.acando.xmltordf.Builder;
import no.acando.xmltordf.CompositeId;
import no.acando.xmltordf.CountingMap;
import no.acando.xmltordf.Property;

public class Element<ResourceType, Datatype> {
    private final AdvancedSaxHandler<ResourceType, Datatype> handler;
    private final Builder.Advanced<ResourceType, Datatype, ? extends Builder.Advanced> builder;
    public String type;
    public String uri;
    public Element<ResourceType, Datatype> parent;
    public StringBuilder hasValue;
    public ArrayList<Element<ResourceType, Datatype>> hasChild = new ArrayList(10);
    public ArrayList<Property> properties = new ArrayList(3);
    long index = 0L;
    long elementIndex = 0L;
    private boolean shallow;
    private boolean autoDetectedAsLiteralProperty;
    CountingMap indexMap = new CountingMap();
    public ArrayList<Object> mixedContent = new ArrayList();
    public StringBuilder tempMixedContentString = new StringBuilder("");
    public boolean useElementAsPredicate;
    boolean containsMixedContent;
    private boolean delayedOutput;
    private Runnable delayedCreateTripleCallback;
    private int childrenWithAutoDetectedAsLiteralProperty;
    public CompositeId compositeId;
    String hasValueString;
    boolean hasValueStringEmpty = false;

    public Element(AdvancedSaxHandler<ResourceType, Datatype> handler, Builder.Advanced<ResourceType, Datatype, ? extends Builder.Advanced> builder) {
        this.handler = handler;
        this.builder = builder;
    }

    public void appendValue(char[] ch, int start, int length) {
        if (!(this.hasChild.isEmpty() || this.containsMixedContent || new String(ch, start, length).trim().isEmpty())) {
            this.containsMixedContent = true;
            this.hasChild.forEach((Consumer<Element<ResourceType, Datatype>>)((Consumer<Element>)e -> this.mixedContent.add(e)));
        }
        if (this.hasValue == null) {
            this.hasValue = new StringBuilder(new String(ch, start, length));
        } else {
            this.hasValue.append(ch, start, length);
        }
        this.tempMixedContentString.append(ch, start, length);
        this.hasValueString = null;
    }

    public String getHasValue() {
        if (this.hasValue == null) {
            return null;
        }
        if (this.hasValueString == null) {
            this.hasValueString = this.hasValue.toString().trim();
            this.hasValueStringEmpty = this.hasValueString.isEmpty();
        }
        if (this.hasValueStringEmpty) {
            return null;
        }
        return this.hasValueString;
    }

    public long getIndex() {
        return this.index;
    }

    public boolean isShallow() {
        return this.shallow;
    }

    public boolean isAutoDetectedAsLiteralProperty() {
        return this.autoDetectedAsLiteralProperty;
    }

    void addMixedContent(Element<ResourceType, Datatype> element) {
        if (!this.containsMixedContent && this.hasChild.size() > 1) {
            for (int i = 0; i < this.hasChild.size() - 1; ++i) {
                this.mixedContent.add(this.hasChild.get(i));
            }
        }
        this.containsMixedContent = true;
        String temp = this.tempMixedContentString.toString();
        if (!temp.isEmpty()) {
            this.mixedContent.add(temp);
        }
        this.tempMixedContentString = new StringBuilder("");
        this.mixedContent.add(element);
    }

    private void endMixedContent() {
        if (this.containsMixedContent && !this.tempMixedContentString.toString().isEmpty()) {
            this.mixedContent.add(this.tempMixedContentString.toString());
        }
    }

    void createTriples() {
        boolean shouldConvertToLiteralProperty;
        if (this.parent != null && this.parent.uri == null) {
            this.parent.compositeId.resolveElement(this.type, this.getHasValue());
            this.parent.addDelayedTripleCreation(this);
            if (this.parent.compositeId.completed()) {
                this.parent.uri = this.parent.compositeId.resolveIdentifier();
            }
            return;
        }
        this.endMixedContent();
        if (this.delayedCreateTripleCallback != null) {
            this.delayedCreateTripleCallback.run();
        }
        this.builder.doComplexTransformElementAtEndOfElement(this);
        if (this.builder.useElementAsPredicateMap != null && this.builder.useElementAsPredicateMap.containsKey(this.type)) {
            this.hasChild.stream().forEach(child -> this.handler.createTriple(this.parent.uri, this.type, child.uri));
            return;
        }
        if (this.parent != null && !this.parent.useElementAsPredicate) {
            if (this.builder.convertComplexElementsWithOnlyAttributesToPredicates && this.hasChild.isEmpty()) {
                this.shallow = true;
            } else if (this.builder.convertComplexElementsWithOnlyAttributesAndSimpleTypeChildrenToPredicate && this.childrenWithAutoDetectedAsLiteralProperty == this.hasChild.size()) {
                this.shallow = true;
            }
            if (this.shallow && this.builder.getInsertPredicateBetweenOrDefaultPredicate(this.parent.type, this.type, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasChild") != "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasChild") {
                this.shallow = false;
            }
        }
        boolean bl = shouldConvertToLiteralProperty = this.builder.autoDetectLiteralProperties && this.hasChild.isEmpty() && this.properties.isEmpty() && this.parent != null && this.parent.mixedContent.isEmpty() && !this.parent.useElementAsPredicate && !this.containsMixedContent;
        if (shouldConvertToLiteralProperty) {
            if (!this.parent.containsMixedContent && !this.delayedOutput && this.parent.getHasValue() == null) {
                if (this.getHasValue() != null) {
                    this.parent.addDelayedTripleCreation(this);
                }
            } else if (this.getHasValue() != null) {
                this.createTriplesForHasValue(this.parent.uri, this.type, this.type);
            }
        } else if (this.shallow) {
            this.handler.createTriple(this.parent.uri, this.type, this.uri);
            if (this.getHasValue() != null) {
                this.createTriplesForHasValue(this.uri, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasValue", this.uri);
            }
            this.addIndexTriples();
            if (!this.mixedContent.isEmpty()) {
                this.handler.createList(this.uri, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasMixedContent", this.mixedContent);
            }
        } else {
            this.handler.createTriple(this.uri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", this.type);
            if (this.parent != null && !this.parent.useElementAsPredicate) {
                String prop = this.builder.getInsertPredicateBetweenOrDefaultPredicate(this.parent.type, this.type, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasChild");
                if (this.builder.checkInvertPredicate(prop, this.parent.type, this.type)) {
                    this.handler.createTriple(this.uri, prop, this.parent.uri);
                } else {
                    this.handler.createTriple(this.parent.uri, prop, this.uri);
                }
            }
            if (this.getHasValue() != null) {
                this.createTriplesForHasValue(this.uri, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasValue", this.type);
            }
            if (!this.mixedContent.isEmpty()) {
                this.handler.createList(this.uri, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasMixedContent", this.mixedContent);
            }
            this.addIndexTriples();
        }
        this.properties.stream().filter(property -> property != null).forEach(property -> {
            ResourceType uriForTextInAttribute = this.builder.getUriForTextInAttribute(this.type, property.uriAttr + property.qname, property.value);
            if (uriForTextInAttribute != null) {
                this.handler.createTriple(this.uri, property.uriAttr + property.qname, uriForTextInAttribute);
            } else {
                this.handler.createTripleLiteral(this.uri, property.uriAttr + property.qname, property.value);
            }
        });
        if (!this.delayedOutput) {
            this.cleanUp();
        }
    }

    private void createTriplesForHasValue(String subject, String predicates, String dataTypeLookup) {
        Optional<ResourceType> resourceType = this.handler.mapLiteralToResource(this);
        this.autoDetectedAsLiteralProperty = true;
        if (this.parent != null) {
            ++this.parent.childrenWithAutoDetectedAsLiteralProperty;
        }
        if (this.builder.dataTypeOnElement != null && this.builder.dataTypeOnElement.containsKey(dataTypeLookup)) {
            if (resourceType.isPresent()) {
                throw new IllegalStateException("Can not both map literal to object and have datatype at the same time.");
            }
            this.handler.createTripleLiteral(subject, predicates, this.getHasValue(), this.builder.dataTypeOnElement.get(dataTypeLookup));
        } else if (resourceType.isPresent()) {
            this.handler.createTriple(subject, predicates, resourceType.get());
        } else {
            this.handler.createTripleLiteral(subject, predicates, this.getHasValue());
        }
    }

    private void addIndexTriples() {
        if (this.builder.addIndex) {
            this.handler.createTripleLiteral(this.uri, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#index", this.index);
            this.handler.createTripleLiteral(this.uri, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#elementIndex", this.elementIndex);
        }
    }

    private void cleanUp() {
        this.hasChild = null;
        this.parent = null;
        this.properties = null;
    }

    public void addDelayedTripleCreation(Element element) {
        element.delayedOutput = true;
        if (this.delayedCreateTripleCallback == null) {
            this.delayedCreateTripleCallback = () -> {
                element.createTriples();
                element.cleanUp();
            };
        } else {
            Runnable delayedCallback = this.delayedCreateTripleCallback;
            this.delayedCreateTripleCallback = () -> {
                element.createTriples();
                element.cleanUp();
                delayedCallback.run();
            };
        }
    }

    public AdvancedSaxHandler<ResourceType, Datatype> getHandler() {
        return this.handler;
    }

    public Builder.Advanced<ResourceType, Datatype, ? extends Builder.Advanced> getBuilder() {
        return this.builder;
    }
}

