/*
 * Decompiled with CFR 0.152.
 */
package no.acando.xmltordf;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import no.acando.xmltordf.Builder;
import no.acando.xmltordf.StringTransformTwoValue;
import no.acando.xmltordf.UndoableBufferedPrintWriter;
import org.apache.jena.vocabulary.RDF;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FastSaxHandler
extends DefaultHandler {
    private final UndoableBufferedPrintWriter out;
    private final Deque<String> nodeIdStack = new ArrayDeque<String>(100);
    private final Deque<StringBuilder> stringBuilderStack = new ArrayDeque<StringBuilder>(100);
    private final Deque<String> typeStack = new ArrayDeque<String>(100);
    private long index = 0L;
    Builder.Fast builder;

    public FastSaxHandler(OutputStream out, Builder.Fast builder) {
        this.out = new UndoableBufferedPrintWriter(new PrintStream(out, false));
        this.builder = builder;
    }

    @Override
    public void endDocument() throws SAXException {
        this.out.flush();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String ns = this.builder.overrideNamespace;
        if (ns != null) {
            uri = ns;
        }
        String fullyQualifiedName = uri + qName;
        if (this.builder.renameElementMap != null && this.builder.renameElementMap.containsKey(uri + localName)) {
            fullyQualifiedName = (String)this.builder.renameElementMap.get(uri + localName);
        } else if (this.builder.renameElementFunctionMap != null) {
            StringTransformTwoValue stringTransformTwoValue = (StringTransformTwoValue)this.builder.renameElementFunctionMap.get(uri + localName);
            if (stringTransformTwoValue == null) {
                stringTransformTwoValue = (StringTransformTwoValue)this.builder.renameElementFunctionMap.get("");
            }
            if (stringTransformTwoValue != null) {
                fullyQualifiedName = stringTransformTwoValue.transform(uri, localName);
            }
        }
        String bnode = "_:index" + this.index++;
        if (this.nodeIdStack.size() > 0) {
            String parent = this.nodeIdStack.peek();
            this.out.println(this.createTriple(parent, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasChild", bnode));
        }
        this.out.println(this.createTriple(bnode, RDF.type.getURI(), fullyQualifiedName));
        this.typeStack.push(fullyQualifiedName);
        this.nodeIdStack.push(bnode);
        this.stringBuilderStack.push(new StringBuilder());
        for (int i = 0; i < attributes.getLength(); ++i) {
            String uriAttr = attributes.getURI(i);
            String nameAttr = attributes.getLocalName(i);
            String valueAttr = attributes.getValue(i);
            if (this.builder.overrideNamespace != null) {
                uriAttr = this.builder.overrideNamespace;
            }
            if (uriAttr == null || uriAttr.trim().isEmpty()) {
                uriAttr = uri;
            }
            valueAttr = this.builder.doTransformForAttribute(uri + localName, uriAttr + nameAttr, valueAttr);
            this.out.println(this.createTripleLiteral(bnode, uriAttr + nameAttr, valueAttr));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String nodeId = this.nodeIdStack.pop();
        String typePop = this.typeStack.pop();
        String value = this.stringBuilderStack.pop().toString().trim();
        if (!value.isEmpty()) {
            this.handleTextValue(nodeId, typePop, value);
        } else if (this.out.peek().equals(this.createTriple(nodeId, RDF.type.getURI(), typePop))) {
            this.cleanUpEmptyTag(nodeId);
        }
    }

    private void cleanUpEmptyTag(String stringPop) {
        String outPop = this.out.pop();
        if (this.out.peek().equals(this.createTriple(this.nodeIdStack.peek(), "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasChild", stringPop))) {
            this.out.pop();
        } else {
            this.out.println(outPop);
        }
    }

    private void handleTextValue(String nodeId, String typePop, String value) {
        if (this.builder.autoDetectLiteralProperties) {
            if (this.out.peek().equals(this.createTriple(nodeId, RDF.type.getURI(), typePop))) {
                if (this.nodeIdStack.isEmpty()) {
                    this.out.println(this.createTripleLiteral(nodeId, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasValue", value));
                } else {
                    this.out.pop();
                    this.out.pop();
                    this.out.println(this.createTripleLiteral(this.nodeIdStack.peek(), typePop, value));
                }
            } else {
                this.out.println(this.createTripleLiteral(nodeId, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasValue", value));
            }
        } else {
            this.out.println(this.createTripleLiteral(nodeId, "http://acandonorway.github.com/XmlToRdf/ontology.ttl#hasValue", value));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.stringBuilderStack.peek().append(ch, start, length);
    }

    private String createTriple(String subject, String predicate, String object) {
        boolean subjectIsBlank = subject.startsWith("_:");
        boolean objectIsBlank = object.startsWith("_:");
        if (subjectIsBlank) {
            if (objectIsBlank) {
                return subject + " <" + predicate + "> " + object + '.';
            }
            return subject + " <" + predicate + "> <" + object + ">.";
        }
        if (objectIsBlank) {
            return '<' + subject + "> <" + predicate + "> " + object + '.';
        }
        return '<' + subject + "> <" + predicate + "> <" + object + ">.";
    }

    private String createTripleLiteral(String subject, String predicate, String literal) {
        literal = literal.replace("\\", "\\\\").replace("\"", "\\\"");
        boolean oIsBlank = subject.startsWith("_:");
        if (oIsBlank) {
            return subject + " <" + predicate + "> \"\"\"" + literal + "\"\"\".";
        }
        return '<' + subject + "> <" + predicate + "> \"\"\"" + literal + "\"\"\" .";
    }
}

