/*
 * Decompiled with CFR 0.152.
 */
package no.acando.xmltordf;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;

public class UndoableBufferedPrintWriter {
    private final PrintStream out;
    private final int SIZE = 10;
    private int counter = 0;
    private final Deque<String> deque = new ArrayDeque<String>(12);

    public UndoableBufferedPrintWriter(PrintStream out) {
        this.out = out;
    }

    void println(String s) {
        this.deque.push(s);
        ++this.counter;
        while (this.counter > 10) {
            this.out.println(this.deque.removeLast());
            --this.counter;
        }
    }

    String peek() {
        return this.deque.peek();
    }

    String pop() {
        --this.counter;
        return this.deque.pop();
    }

    void flush() {
        try {
            while (true) {
                this.out.println(this.deque.pop());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.flush();
            return;
        }
    }
}

