/*
 * Decompiled with CFR 0.152.
 */
package no.acando.xmltordf;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import no.acando.xmltordf.AdvancedSaxHandlerJena;
import no.acando.xmltordf.Builder;
import no.acando.xmltordf.PostProcessingJena;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToRdfAdvancedJena {
    Builder.AdvancedJena builder;

    public XmlToRdfAdvancedJena(Builder.AdvancedJena builder) {
        this.builder = builder;
    }

    public Dataset convertToDataset(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        AdvancedSaxHandlerJena handler = new AdvancedSaxHandlerJena(this.builder);
        saxParser.parse(in, (DefaultHandler)handler);
        return handler.dataset;
    }

    public PostProcessingJena convertForPostProcessing(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        Model model = this.convertToDataset(inputStream).getDefaultModel();
        inputStream.close();
        return new PostProcessingJena(model);
    }
}

