/*
 * Decompiled with CFR 0.152.
 */
package no.api.freemarker.java8.time;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import no.api.freemarker.java8.time.AbstractAdapter;
import no.api.freemarker.java8.time.AbstractFormatter;
import no.api.freemarker.java8.time.DateTimeTools;

public class ZonedDateTimeAdapter
extends AbstractAdapter<ZonedDateTime>
implements AdapterTemplateModel,
TemplateScalarModel,
TemplateHashModel {
    public ZonedDateTimeAdapter(ZonedDateTime obj) {
        super(obj);
    }

    public TemplateModel get(String s) throws TemplateModelException {
        if ("format".equals(s)) {
            return new ZonedDateTimeFormatter((ZonedDateTime)this.getObject());
        }
        throw new TemplateModelException("Unknown method call: " + s);
    }

    public class ZonedDateTimeFormatter
    extends AbstractFormatter<ZonedDateTime>
    implements TemplateMethodModelEx {
        public ZonedDateTimeFormatter(ZonedDateTime obj) {
            super(obj);
        }

        public Object exec(List list) throws TemplateModelException {
            ZoneId zoneId = DateTimeTools.zoneIdLookup(list, 1);
            if (this.isDifferentTimeZoneRequested(zoneId)) {
                return ((ZonedDateTime)this.getObject()).withZoneSameInstant(zoneId).format(DateTimeTools.createDateTimeFormatter(list, 0, DateTimeFormatter.ISO_ZONED_DATE_TIME));
            }
            return ((ZonedDateTime)this.getObject()).format(DateTimeTools.createDateTimeFormatter(list, 0, DateTimeFormatter.ISO_ZONED_DATE_TIME));
        }

        private boolean isDifferentTimeZoneRequested(ZoneId zoneId) {
            return !((ZonedDateTime)this.getObject()).getZone().equals(zoneId);
        }
    }
}

