/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.banking;

import java.math.BigInteger;
import no.bekk.bekkopen.banking.KidnummerValidator;
import no.bekk.bekkopen.common.Checksums;
import no.bekk.bekkopen.common.StringNumber;

public class Kidnummer
extends StringNumber {
    Kidnummer(String kidnummer) {
        super(kidnummer);
    }

    public static Kidnummer mod10Kid(String baseNumber) {
        return Kidnummer.mod10Kid(baseNumber, baseNumber.length() + 1);
    }

    public static Kidnummer mod10Kid(String baseNumber, int targetLength) {
        if (baseNumber.length() >= targetLength) {
            throw new IllegalArgumentException("baseNumber too long");
        }
        String padded = String.format("%0" + (targetLength - 1) + "d", new BigInteger(baseNumber));
        Kidnummer k = new Kidnummer(padded + "0");
        return KidnummerValidator.getKidnummer(padded + Checksums.calculateMod10CheckSum(Checksums.getMod10Weights(k), k));
    }

    public static Kidnummer mod11Kid(String baseNumber) {
        return Kidnummer.mod11Kid(baseNumber, baseNumber.length() + 1);
    }

    public static Kidnummer mod11Kid(String baseNumber, int targetLength) {
        if (baseNumber.length() >= targetLength) {
            throw new IllegalArgumentException("baseNumber too long");
        }
        String padded = String.format("%0" + (targetLength - 1) + "d", new BigInteger(baseNumber));
        Kidnummer k = new Kidnummer(padded + "0");
        return KidnummerValidator.getKidnummer(padded + Checksums.calculateMod11CheckSumAllowDash(Checksums.getMod11Weights(k), k));
    }
}

