/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.banking;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import no.bekk.bekkopen.banking.annotation.Kidnummer;
import no.bekk.bekkopen.common.Checksums;
import no.bekk.bekkopen.common.StringNumberValidator;

public class KidnummerValidator
extends StringNumberValidator
implements ConstraintValidator<Kidnummer, String> {
    public static final String ERROR_LENGTH = "A Kidnummer is between 3(+1) and 25 digits";

    private KidnummerValidator() {
    }

    public static boolean isValid(String kidnummer) {
        try {
            KidnummerValidator.getKidnummer(kidnummer);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static no.bekk.bekkopen.banking.Kidnummer getKidnummer(String kidnummer) throws IllegalArgumentException {
        KidnummerValidator.validateSyntax(kidnummer);
        KidnummerValidator.validateChecksum(kidnummer);
        return new no.bekk.bekkopen.banking.Kidnummer(kidnummer);
    }

    static void validateSyntax(String kidnummer) {
        KidnummerValidator.validateAllDigits(kidnummer.replace("-", ""));
        KidnummerValidator.validateLengthInRange(kidnummer, 4, 25);
    }

    private static void validateLengthInRange(String kidnummer, int i, int j) {
        if (kidnummer == null || kidnummer.length() < i || kidnummer.length() > j) {
            throw new IllegalArgumentException(ERROR_LENGTH);
        }
    }

    public static void validateChecksum(String kidnummer) {
        no.bekk.bekkopen.banking.Kidnummer k = new no.bekk.bekkopen.banking.Kidnummer(kidnummer);
        int kMod10 = Checksums.calculateMod10CheckSum(Checksums.getMod10Weights(k), k);
        if (kMod10 == k.getChecksumDigit()) {
            return;
        }
        String kMod11 = Checksums.calculateMod11CheckSumAllowDash(Checksums.getMod11Weights(k), k);
        if ("-".equals(kMod11) || Integer.parseInt(kMod11) == k.getChecksumDigit()) {
            return;
        }
        throw new IllegalArgumentException("Invalid checksum : " + kidnummer);
    }

    public void initialize(Kidnummer constraintAnnotation) {
    }

    public boolean isValid(String kidnummer, ConstraintValidatorContext context) {
        if (kidnummer == null) {
            return true;
        }
        return KidnummerValidator.isValid(kidnummer);
    }
}

