/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.banking;

import java.util.ArrayList;
import java.util.List;
import no.bekk.bekkopen.banking.Kontonummer;
import no.bekk.bekkopen.banking.KontonummerValidator;

public class KontonummerCalculator {
    private static final int LENGTH = 11;
    private static final int REGISTERNUMMER_START_DIGIT = 0;
    private static final int ACCOUNTTYPE_START_DIGIT = 4;

    private KontonummerCalculator() {
    }

    private static List<Kontonummer> getKontonummerListUsingGenerator(KontonummerDigitGenerator generator, int length) {
        ArrayList<Kontonummer> result = new ArrayList<Kontonummer>();
        int numAddedToList = 0;
        while (numAddedToList < length) {
            Kontonummer kontoNr;
            try {
                kontoNr = KontonummerValidator.getAndForceValidKontonummer(generator.generateKontonummer());
            }
            catch (IllegalArgumentException iae) {
                continue;
            }
            result.add(kontoNr);
            ++numAddedToList;
        }
        return result;
    }

    public static List<Kontonummer> getKontonummerListForAccountType(String accountType, int length) {
        KontonummerValidator.validateAccountTypeSyntax(accountType);
        final class AccountTypeKontonrDigitGenerator
        extends KontonummerDigitGenerator {
            private final String accountType;

            AccountTypeKontonrDigitGenerator(String accountType) {
                this.accountType = accountType;
            }

            @Override
            String generateKontonummer() {
                StringBuilder kontonrBuffer = new StringBuilder(11);
                int i = 0;
                while (i < 11) {
                    if (i == 4) {
                        kontonrBuffer.append(this.accountType);
                        i += this.accountType.length();
                        continue;
                    }
                    kontonrBuffer.append((int)(Math.random() * 10.0));
                    ++i;
                }
                return kontonrBuffer.toString();
            }
        }
        return KontonummerCalculator.getKontonummerListUsingGenerator(new AccountTypeKontonrDigitGenerator(accountType), length);
    }

    public static List<Kontonummer> getKontonummerListForRegisternummer(String registernummer, int length) {
        KontonummerValidator.validateRegisternummerSyntax(registernummer);
        final class RegisternummerKontonrDigitGenerator
        extends KontonummerDigitGenerator {
            private final String registerNr;

            RegisternummerKontonrDigitGenerator(String registerNr) {
                this.registerNr = registerNr;
            }

            @Override
            String generateKontonummer() {
                StringBuilder kontonrBuffer = new StringBuilder(11);
                int i = 0;
                while (i < 11) {
                    if (i == 0) {
                        kontonrBuffer.append(this.registerNr);
                        i += this.registerNr.length();
                        continue;
                    }
                    kontonrBuffer.append((int)(Math.random() * 10.0));
                    ++i;
                }
                return kontonrBuffer.toString();
            }
        }
        return KontonummerCalculator.getKontonummerListUsingGenerator(new RegisternummerKontonrDigitGenerator(registernummer), length);
    }

    public static List<Kontonummer> getKontonummerList(int length) {
        final class NormalKontonrDigitGenerator
        extends KontonummerDigitGenerator {
            NormalKontonrDigitGenerator() {
            }

            @Override
            String generateKontonummer() {
                StringBuilder kontonrBuffer = new StringBuilder(11);
                for (int i = 0; i < 11; ++i) {
                    kontonrBuffer.append((int)(Math.random() * 10.0));
                }
                return kontonrBuffer.toString();
            }
        }
        return KontonummerCalculator.getKontonummerListUsingGenerator(new NormalKontonrDigitGenerator(), length);
    }

    private static abstract class KontonummerDigitGenerator {
        private KontonummerDigitGenerator() {
        }

        abstract String generateKontonummer();
    }
}

