/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.common;

import no.bekk.bekkopen.common.StringNumber;

public class Checksums {
    public static final String ERROR_INVALID_CHECKSUM = "Invalid checksum : ";
    private static int[] BASE_MOD11_WEIGHTS = new int[]{2, 3, 4, 5, 6, 7};

    public static int calculateMod11CheckSum(int[] weights, StringNumber number) {
        int c = Checksums.calculateChecksum(weights, number, false) % 11;
        if (c == 1) {
            throw new IllegalArgumentException(ERROR_INVALID_CHECKSUM + number);
        }
        return c == 0 ? 0 : 11 - c;
    }

    public static String calculateMod11CheckSumAllowDash(int[] weights, StringNumber number) {
        int c = Checksums.calculateChecksum(weights, number, false) % 11;
        if (c == 1) {
            return "-";
        }
        return String.valueOf(c == 0 ? 0 : 11 - c);
    }

    public static int calculateMod10CheckSum(int[] weights, StringNumber number) {
        int c = Checksums.calculateChecksum(weights, number, true) % 10;
        return c == 0 ? 0 : 10 - c;
    }

    public static int calculateChecksum(int[] weights, StringNumber number, boolean tverrsum) {
        int checkSum = 0;
        for (int i = 0; i < weights.length; ++i) {
            int product = weights[i] * number.getAt(weights.length - 1 - i);
            if (tverrsum) {
                checkSum += product > 9 ? product - 9 : product;
                continue;
            }
            checkSum += product;
        }
        return checkSum;
    }

    public static int[] getMod10Weights(StringNumber k) {
        int[] weights = new int[k.getLength() - 1];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = i % 2 == 0 ? 2 : 1;
        }
        return weights;
    }

    public static int[] getMod11Weights(StringNumber k) {
        int[] weights = new int[k.getLength() - 1];
        for (int i = 0; i < weights.length; ++i) {
            int j = i % BASE_MOD11_WEIGHTS.length;
            weights[i] = BASE_MOD11_WEIGHTS[j];
        }
        return weights;
    }
}

