/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.date;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NorwegianDateUtil {
    private static Map<Integer, Set<Date>> holidays;

    public static Date addWorkingDaysToDate(Date date, int days) {
        Calendar cal = NorwegianDateUtil.dateToCalendar(date);
        for (int i = 0; i < days; ++i) {
            cal.add(5, 1);
            while (!NorwegianDateUtil.isWorkingDay(cal)) {
                cal.add(5, 1);
            }
        }
        return cal.getTime();
    }

    public static boolean isWorkingDay(Date date) {
        return NorwegianDateUtil.isWorkingDay(NorwegianDateUtil.dateToCalendar(date));
    }

    public static boolean isHoliday(Date date) {
        return NorwegianDateUtil.isHoliday(NorwegianDateUtil.dateToCalendar(date));
    }

    public static Date[] getHolidays(int year) {
        Set<Date> days = NorwegianDateUtil.getHolidaySet(year);
        Object[] dates = days.toArray(new Date[days.size()]);
        Arrays.sort(dates);
        return dates;
    }

    private static Set<Date> getHolidaySet(int year) {
        if (holidays == null) {
            holidays = new HashMap<Integer, Set<Date>>();
        }
        if (!holidays.containsKey(year)) {
            HashSet<Date> yearSet = new HashSet<Date>();
            yearSet.add(NorwegianDateUtil.getDate(1, 0, year));
            yearSet.add(NorwegianDateUtil.getDate(1, 4, year));
            yearSet.add(NorwegianDateUtil.getDate(17, 4, year));
            yearSet.add(NorwegianDateUtil.getDate(25, 11, year));
            yearSet.add(NorwegianDateUtil.getDate(26, 11, year));
            Calendar easterDay = NorwegianDateUtil.dateToCalendar(NorwegianDateUtil.getEasterDay(year));
            yearSet.add(NorwegianDateUtil.rollGetDate(easterDay, -7));
            yearSet.add(NorwegianDateUtil.rollGetDate(easterDay, -3));
            yearSet.add(NorwegianDateUtil.rollGetDate(easterDay, -2));
            yearSet.add(easterDay.getTime());
            yearSet.add(NorwegianDateUtil.rollGetDate(easterDay, 1));
            yearSet.add(NorwegianDateUtil.rollGetDate(easterDay, 39));
            yearSet.add(NorwegianDateUtil.rollGetDate(easterDay, 49));
            yearSet.add(NorwegianDateUtil.rollGetDate(easterDay, 50));
            holidays.put(year, yearSet);
        }
        return holidays.get(year);
    }

    private static boolean isWorkingDay(Calendar cal) {
        return cal.get(7) != 7 && cal.get(7) != 1 && !NorwegianDateUtil.isHoliday(cal);
    }

    private static boolean isHoliday(Calendar cal) {
        int year = cal.get(1);
        Set<Date> yearSet = NorwegianDateUtil.getHolidaySet(year);
        for (Date aYearSet : yearSet) {
            Date date = aYearSet;
            if (!NorwegianDateUtil.checkDate(cal, NorwegianDateUtil.dateToCalendar(date))) continue;
            return true;
        }
        return false;
    }

    private static Date getEasterDay(int year) {
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int n = (h + l - 7 * m + 114) / 31;
        int p = (h + l - 7 * m + 114) % 31;
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, n - 1);
        cal.set(5, p + 1);
        return cal.getTime();
    }

    private static boolean checkDate(Calendar cal, Calendar other) {
        return NorwegianDateUtil.checkDate(cal, other.get(5), other.get(2));
    }

    private static boolean checkDate(Calendar cal, int date, int month) {
        return cal.get(5) == date && cal.get(2) == month;
    }

    private static Calendar dateToCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private static Date rollGetDate(Calendar calendar, int days) {
        Calendar easterSunday = (Calendar)calendar.clone();
        easterSunday.add(5, days);
        return easterSunday.getTime();
    }

    private static Date getDate(int day, int month, int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return cal.getTime();
    }
}

