/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.StringTokenizer;
import no.bekk.bekkopen.mail.MailValidator;
import no.bekk.bekkopen.mail.model.Kommunenavn;
import no.bekk.bekkopen.mail.model.Kommunenummer;
import no.bekk.bekkopen.mail.model.PostInfo;
import no.bekk.bekkopen.mail.model.Postnummer;
import no.bekk.bekkopen.mail.model.PostnummerKategori;
import no.bekk.bekkopen.mail.model.Poststed;

public class MailDataLoader {
    private MailDataLoader() {
    }

    public static void loadFromInputStream(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        HashMap<Postnummer, PostInfo> postInfo = new HashMap<Postnummer, PostInfo>();
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, ",", false);
                Postnummer postnummer = MailValidator.getPostnummer(st.nextToken());
                Poststed poststed = new Poststed(st.nextToken());
                Kommunenummer kommunenummer = MailValidator.getKommunenummer(st.nextToken());
                Kommunenavn kommunenavn = new Kommunenavn(st.nextToken());
                PostnummerKategori postnummerKategori = MailValidator.getPostnummerKategori(st.nextToken());
                postInfo.put(postnummer, new PostInfo(postnummer, poststed, kommunenummer, kommunenavn, postnummerKategori));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MailValidator.setPostInfo(postInfo);
    }

    public static boolean loadFromClassPath() {
        boolean success = false;
        try (InputStream is = MailDataLoader.class.getResourceAsStream("/postnummer.csv");){
            MailDataLoader.loadFromInputStream(is);
            success = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return success;
    }
}

