/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import no.bekk.bekkopen.common.HelperFunctions;
import no.bekk.bekkopen.common.StringNumberValidator;
import no.bekk.bekkopen.mail.model.Kommunenavn;
import no.bekk.bekkopen.mail.model.Kommunenummer;
import no.bekk.bekkopen.mail.model.PostInfo;
import no.bekk.bekkopen.mail.model.Postnummer;
import no.bekk.bekkopen.mail.model.PostnummerKategori;
import no.bekk.bekkopen.mail.model.Poststed;

public class MailValidator
extends StringNumberValidator {
    private static final int POSTNUMMER_LENGTH = 4;
    private static final int KOMMUNENUMMER_LENGTH = 4;
    private static Map<Postnummer, PostInfo> postInfo = new HashMap<Postnummer, PostInfo>();

    public static Postnummer getPostnummer(String postnummer) {
        MailValidator.validatePostnummerSyntax(postnummer);
        return new Postnummer(postnummer);
    }

    public static Kommunenummer getKommunenummer(String kommunenummer) {
        MailValidator.validateKommunenummerSyntax(kommunenummer);
        return new Kommunenummer(kommunenummer);
    }

    public static PostnummerKategori getPostnummerKategori(String postnummerKategori) {
        return PostnummerKategori.fromString(postnummerKategori);
    }

    public static void setPostInfo(Map<Postnummer, PostInfo> postInfo) {
        MailValidator.postInfo = postInfo;
    }

    public static boolean isValidPostnummer(String postnummer) {
        try {
            MailValidator.getPostnummer(postnummer);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static void validatePostnummerSyntax(String postnummer) {
        MailValidator.validateLengthAndAllDigits(postnummer, 4);
    }

    public static boolean isValidKommunenummer(String kommunenummer) {
        try {
            MailValidator.getKommunenummer(kommunenummer);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static void validateKommunenummerSyntax(String kommunenummer) {
        MailValidator.validateLengthAndAllDigits(kommunenummer, 4);
    }

    public static int getAntallPoststed() {
        return (int)postInfo.entrySet().stream().map(s -> (PostInfo)s.getValue()).filter(HelperFunctions.distinctByKey(PostInfo::getPoststed)).count();
    }

    public static int getAntallPostnummer() {
        return postInfo.size();
    }

    public static int getAntallKommunenummer() {
        return (int)postInfo.entrySet().stream().map(s -> (PostInfo)s.getValue()).filter(HelperFunctions.distinctByKey(PostInfo::getKommunenummer)).count();
    }

    public static PostInfo getPostInfoForPostnummer(String postnummer) {
        PostInfo result = null;
        Postnummer pn = MailValidator.getPostnummer(postnummer);
        if (postInfo.containsKey(pn)) {
            result = postInfo.get(pn);
        }
        return result;
    }

    public static Poststed getPoststedForPostnummer(String postnummer) {
        return MailValidator.getPostInfoForPostnummer(postnummer).getPoststed();
    }

    public static Kommunenavn getKommunenavnForPostnummer(String postnummer) {
        return MailValidator.getPostInfoForPostnummer(postnummer).getKommunenavn();
    }

    public static Kommunenummer getKommunenummerForPostnummer(String postnummer) {
        return MailValidator.getPostInfoForPostnummer(postnummer).getKommunenummer();
    }

    public static PostnummerKategori getPostnummerKategoriForPostnummer(String postnummer) {
        return MailValidator.getPostInfoForPostnummer(postnummer).getPostnummerKategori();
    }

    public static List<Postnummer> getPostnummerForPoststed(String poststed) {
        Poststed p = new Poststed(poststed);
        ArrayList postnummerList = postInfo.entrySet().stream().filter(a -> ((PostInfo)a.getValue()).getPoststed().equals(p)).map(x -> ((PostInfo)x.getValue()).getPostnummer()).collect(Collectors.toList());
        return postnummerList == null ? new ArrayList() : postnummerList;
    }

    public static Optional<PostInfo> getPostInfoForKommunenummer(String kommunenummer) {
        return postInfo.entrySet().stream().map(s -> (PostInfo)s.getValue()).filter(s -> s.getKommunenummer().toString().equals(kommunenummer)).findFirst();
    }

    public static Kommunenavn getKommunenavnForKommunenummer(String kommunenummer) {
        Optional<PostInfo> result = MailValidator.getPostInfoForKommunenummer(kommunenummer);
        return result.isPresent() ? result.get().getKommunenavn() : null;
    }

    public static Optional<PostInfo> getPostInfoForKommunenavn(String kommunenavn) {
        return postInfo.entrySet().stream().map(s -> (PostInfo)s.getValue()).filter(s -> s.getKommunenavn().toString().equalsIgnoreCase(kommunenavn)).findFirst();
    }

    public static Kommunenummer getKommunenummerForKommunenavn(String kommunenavn) {
        Optional<PostInfo> result = MailValidator.getPostInfoForKommunenavn(kommunenavn);
        return result.isPresent() ? result.get().getKommunenummer() : null;
    }
}

