/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.org;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import no.bekk.bekkopen.common.Checksums;
import no.bekk.bekkopen.common.StringNumberValidator;
import no.bekk.bekkopen.org.Organisasjonsnummer;

public class OrganisasjonsnummerValidator
extends StringNumberValidator
implements ConstraintValidator<no.bekk.bekkopen.org.annotation.Organisasjonsnummer, String> {
    private static final int LENGTH = 9;

    public static boolean isValid(String organisasjonsnummer) {
        try {
            OrganisasjonsnummerValidator.getOrganisasjonsnummer(organisasjonsnummer);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Organisasjonsnummer getOrganisasjonsnummer(String organisasjonsnummer) throws IllegalArgumentException {
        OrganisasjonsnummerValidator.validateSyntax(organisasjonsnummer);
        OrganisasjonsnummerValidator.validateChecksum(organisasjonsnummer);
        return new Organisasjonsnummer(organisasjonsnummer);
    }

    public static Organisasjonsnummer getAndForceValidOrganisasjonsnummer(String organisasjonsnummer) {
        OrganisasjonsnummerValidator.validateSyntax(organisasjonsnummer);
        try {
            OrganisasjonsnummerValidator.validateChecksum(organisasjonsnummer);
        }
        catch (IllegalArgumentException iae) {
            Organisasjonsnummer onr = new Organisasjonsnummer(organisasjonsnummer);
            int checksum = Checksums.calculateMod11CheckSum(Checksums.getMod11Weights(onr), onr);
            organisasjonsnummer = organisasjonsnummer.substring(0, 8) + checksum;
        }
        return new Organisasjonsnummer(organisasjonsnummer);
    }

    static void validateSyntax(String organisasjonsnummer) {
        OrganisasjonsnummerValidator.validateLengthAndAllDigits(organisasjonsnummer, 9);
    }

    static void validateChecksum(String organisasjonsnummer) {
        Organisasjonsnummer onr = new Organisasjonsnummer(organisasjonsnummer);
        int k1 = Checksums.calculateMod11CheckSum(Checksums.getMod11Weights(onr), onr);
        if (k1 != onr.getChecksumDigit()) {
            throw new IllegalArgumentException("Invalid checksum : " + organisasjonsnummer);
        }
    }

    public void initialize(no.bekk.bekkopen.org.annotation.Organisasjonsnummer constraintAnnotation) {
    }

    public boolean isValid(String organisasjonsnummer, ConstraintValidatorContext context) {
        if (organisasjonsnummer == null) {
            return true;
        }
        return OrganisasjonsnummerValidator.isValid(organisasjonsnummer);
    }
}

