/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.person;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import no.bekk.bekkopen.person.Fodselsnummer;
import no.bekk.bekkopen.person.FodselsnummerValidator;
import no.bekk.bekkopen.person.KJONN;

public class FodselsnummerCalculator {
    private FodselsnummerCalculator() {
    }

    public static List<Fodselsnummer> getFodselsnummerForDateAndGender(Date date, KJONN kjonn) {
        List<Fodselsnummer> result = FodselsnummerCalculator.getManyFodselsnummerForDate(date);
        FodselsnummerCalculator.splitByGender(kjonn, result);
        return result;
    }

    public static Fodselsnummer getFodselsnummerForDate(Date date) {
        List<Fodselsnummer> fodselsnummerList = FodselsnummerCalculator.getManyFodselsnummerForDate(date);
        Collections.shuffle(fodselsnummerList);
        return fodselsnummerList.get(0);
    }

    public static List<Fodselsnummer> getManyDNumberFodselsnummerForDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        String centuryString = FodselsnummerCalculator.getCentury(date);
        String dateString = df.format(date);
        dateString = Character.toChars(dateString.charAt(0) + 4)[0] + dateString.substring(1);
        return FodselsnummerCalculator.generateFodselsnummerForDate(dateString, centuryString);
    }

    public static List<Fodselsnummer> getManySynteticFodselsnummerForDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        String centuryString = FodselsnummerCalculator.getCentury(date);
        String dateString = df.format(date);
        dateString = dateString.substring(0, 2) + Character.toChars(dateString.charAt(2) + 8)[0] + dateString.substring(3);
        return FodselsnummerCalculator.generateFodselsnummerForDate(dateString, centuryString);
    }

    public static List<Fodselsnummer> getManySynteticDNumberFodselsnummerForDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        String centuryString = FodselsnummerCalculator.getCentury(date);
        String dateString = df.format(date);
        dateString = Character.toChars(dateString.charAt(0) + 4)[0] + dateString.substring(1, 2) + Character.toChars(dateString.charAt(2) + 8)[0] + dateString.substring(3);
        return FodselsnummerCalculator.generateFodselsnummerForDate(dateString, centuryString);
    }

    public static List<Fodselsnummer> getManyFodselsnummerForDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        String centuryString = FodselsnummerCalculator.getCentury(date);
        String dateString = df.format(date);
        return FodselsnummerCalculator.generateFodselsnummerForDate(dateString, centuryString);
    }

    private static List<Fodselsnummer> generateFodselsnummerForDate(String dateString, String centuryString) {
        ArrayList<Fodselsnummer> result = new ArrayList<Fodselsnummer>();
        for (int i = 999; i >= 0; --i) {
            StringBuilder sb = new StringBuilder(dateString);
            if (i < 10) {
                sb.append("00");
            } else if (i < 100) {
                sb.append("0");
            }
            sb.append(i);
            Fodselsnummer fodselsnummer = new Fodselsnummer(sb.toString());
            try {
                sb.append(FodselsnummerValidator.calculateFirstChecksumDigit(fodselsnummer));
                fodselsnummer = new Fodselsnummer(sb.toString());
                sb.append(FodselsnummerValidator.calculateSecondChecksumDigit(fodselsnummer));
                fodselsnummer = new Fodselsnummer(sb.toString());
                String centuryByIndividnummer = fodselsnummer.getCentury();
                if (centuryByIndividnummer == null || !centuryByIndividnummer.equals(centuryString) || !FodselsnummerValidator.isValid(fodselsnummer.getValue())) continue;
                result.add(fodselsnummer);
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return result;
    }

    private static String getCentury(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        return Integer.toString(year).substring(0, 2);
    }

    private static void splitByGender(KJONN kjonn, List<Fodselsnummer> result) {
        Iterator<Fodselsnummer> iter = result.iterator();
        while (iter.hasNext()) {
            Fodselsnummer f = iter.next();
            if (f.getKjonn() == kjonn) continue;
            iter.remove();
        }
    }
}

