/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.person;

public class Navn {
    private final String fornavn;
    private String mellomnavn;
    private final String etternavn;

    Navn(String fornavn, String mellomnavn, String etternavn) {
        this(fornavn, etternavn);
        if (null != mellomnavn) {
            this.mellomnavn = this.korrigerCasing(mellomnavn);
        }
    }

    public Navn(String fornavn, String etternavn) {
        if (null == fornavn || null == etternavn) {
            throw new IllegalArgumentException("fornavn or etternavn can not be null: fornavn=" + fornavn + ",etternavn=" + etternavn);
        }
        this.fornavn = this.korrigerCasing(fornavn);
        this.etternavn = this.korrigerCasing(etternavn);
    }

    public String getFornavn() {
        return this.fornavn;
    }

    public String getMellomnavn() {
        return this.mellomnavn;
    }

    public String getEtternavn() {
        return this.etternavn;
    }

    public String getNavn() {
        StringBuilder navn = new StringBuilder(this.fornavn);
        if (null != this.mellomnavn) {
            navn.append(" ").append(this.mellomnavn);
        }
        navn.append(" ").append(this.etternavn);
        return navn.toString();
    }

    public String toString() {
        return this.getNavn();
    }

    private String korrigerCasing(String navn) {
        if (navn.length() == 0) {
            return "";
        }
        if (navn.length() == 1) {
            return navn.toUpperCase();
        }
        StringBuilder korrigetNavn = new StringBuilder(navn.substring(0, 1).toUpperCase());
        korrigetNavn.append(navn.substring(1, navn.length()).toLowerCase());
        return korrigetNavn.toString();
    }
}

