/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.person;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import no.bekk.bekkopen.person.KJONN;
import no.bekk.bekkopen.person.Navn;

public class NavnGenerator {
    private static final int caAntallKvinnerSomHarMellomnavnIProsent = 22;
    private static final int caAntallMennSomHarMellomnavnIProsent = 14;
    private static final List<String> kvinnenavn = NavnGenerator.csv2List(NavnGenerator.class.getResourceAsStream("/fornavn_kvinner.csv"));
    private static final List<String> mannsnavn = NavnGenerator.csv2List(NavnGenerator.class.getResourceAsStream("/fornavn_menn.csv"));
    private static final List<String> etternavn = NavnGenerator.csv2List(NavnGenerator.class.getResourceAsStream("/etternavn.csv"));

    private NavnGenerator() {
    }

    public static Navn genererMannsnavn() {
        return NavnGenerator.genererNavn(1, KJONN.MANN).get(0);
    }

    public static Navn genererKvinnenavn() {
        return NavnGenerator.genererNavn(1, KJONN.KVINNE).get(0);
    }

    public static List<Navn> genererMannsnavn(int antall) {
        return NavnGenerator.genererNavn(antall, KJONN.MANN);
    }

    public static List<Navn> genererKvinnenavn(int antall) {
        return NavnGenerator.genererNavn(antall, KJONN.KVINNE);
    }

    public static List<Navn> genererNavn(int antall) {
        return NavnGenerator.genererNavn(antall, KJONN.BEGGE);
    }

    private static List<Navn> genererNavn(int antall, KJONN kjonn) {
        ArrayList<Navn> navneliste = new ArrayList<Navn>(antall);
        KJONN kjonnSwitch = kjonn;
        while (navneliste.size() < antall) {
            Navn navn;
            if (KJONN.erBegge(kjonn)) {
                kjonnSwitch = KJONN.byttKjonn(kjonn);
            }
            if (navneliste.contains(navn = NavnGenerator.genererNavn(kjonnSwitch))) continue;
            navneliste.add(navn);
        }
        return navneliste;
    }

    private static Navn genererNavn(KJONN kjonn) {
        String fnavn;
        String mnavn = null;
        if (KJONN.erKvinne(kjonn)) {
            int indexF = new Random().nextInt(kvinnenavn.size() - 1);
            fnavn = kvinnenavn.get(indexF);
        } else {
            int indexF = new Random().nextInt(mannsnavn.size() - 1);
            fnavn = mannsnavn.get(indexF);
        }
        if (NavnGenerator.genererMellomnavn(kjonn)) {
            int indexM = new Random().nextInt(etternavn.size() - 1);
            mnavn = etternavn.get(indexM);
        }
        int indexE = new Random().nextInt(etternavn.size() - 1);
        String enavn = etternavn.get(indexE);
        return new Navn(fnavn, mnavn, enavn);
    }

    private static boolean genererMellomnavn(KJONN kjonn) {
        return KJONN.erKvinne(kjonn) ? new Random().nextInt(100) <= 22 : new Random().nextInt(100) <= 14;
    }

    private static List<String> csv2List(InputStream is) {
        InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(isr);
        ArrayList<String> vList = new ArrayList<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] array = line.split("[ ]*,[ ]*");
                Collections.addAll(vList, array);
            }
            br.close();
            isr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return vList;
    }
}

