/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.banking;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import no.bekk.bekkopen.banking.annotation.Kontonummer;
import no.bekk.bekkopen.common.Checksums;
import no.bekk.bekkopen.common.StringNumberValidator;

public class KontonummerValidator
extends StringNumberValidator
implements ConstraintValidator<Kontonummer, String> {
    private static final int LENGTH = 11;
    protected static final int ACCOUNTTYPE_NUM_DIGITS = 2;
    protected static final int REGISTERNUMMER_NUM_DIGITS = 4;
    private static final String NOT_ALLOWED_AS_LEADING = "0000";
    public static final String ERROR_LEADING_ZEROS = "Leading zeros too many : ";

    private KontonummerValidator() {
    }

    public static boolean isValid(String kontonummer) {
        try {
            KontonummerValidator.getKontonummer(kontonummer);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static no.bekk.bekkopen.banking.Kontonummer getKontonummer(String kontonummer) throws IllegalArgumentException {
        KontonummerValidator.validateSyntax(kontonummer);
        KontonummerValidator.validateChecksum(kontonummer);
        return new no.bekk.bekkopen.banking.Kontonummer(kontonummer);
    }

    public static no.bekk.bekkopen.banking.Kontonummer getAndForceValidKontonummer(String kontonummer) {
        KontonummerValidator.validateSyntax(kontonummer);
        try {
            KontonummerValidator.validateChecksum(kontonummer);
        }
        catch (IllegalArgumentException iae) {
            no.bekk.bekkopen.banking.Kontonummer k = new no.bekk.bekkopen.banking.Kontonummer(kontonummer);
            int checksum = Checksums.calculateMod11CheckSum(Checksums.getMod11Weights(k), k);
            kontonummer = kontonummer.substring(0, 10) + checksum;
        }
        return new no.bekk.bekkopen.banking.Kontonummer(kontonummer);
    }

    static void validateSyntax(String kontonummer) {
        if (kontonummer.startsWith(NOT_ALLOWED_AS_LEADING)) {
            throw new IllegalArgumentException(ERROR_LEADING_ZEROS + kontonummer);
        }
        KontonummerValidator.validateLengthAndAllDigits(kontonummer, 11);
    }

    static void validateAccountTypeSyntax(String accountType) {
        KontonummerValidator.validateLengthAndAllDigits(accountType, 2);
    }

    static void validateRegisternummerSyntax(String registernummer) {
        KontonummerValidator.validateLengthAndAllDigits(registernummer, 4);
    }

    static void validateChecksum(String kontonummer) {
        no.bekk.bekkopen.banking.Kontonummer k = new no.bekk.bekkopen.banking.Kontonummer(kontonummer);
        int k1 = Checksums.calculateMod11CheckSum(Checksums.getMod11Weights(k), k);
        if (k1 != k.getChecksumDigit()) {
            throw new IllegalArgumentException("Invalid checksum : " + kontonummer);
        }
    }

    public void initialize(Kontonummer constraintAnnotation) {
    }

    public boolean isValid(String kontonummer, ConstraintValidatorContext context) {
        if (kontonummer == null) {
            return true;
        }
        return KontonummerValidator.isValid(kontonummer);
    }
}

