/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.person;

import no.bekk.bekkopen.common.StringNumber;
import no.bekk.bekkopen.person.KJONN;

public class Fodselsnummer
extends StringNumber {
    Fodselsnummer(String fodselsnummer) {
        super(fodselsnummer);
    }

    public String getDateAndMonth() {
        return Fodselsnummer.parseSyntheticNumber(Fodselsnummer.parseDNumber(this.getValue())).substring(0, 4);
    }

    public String getDayInMonth() {
        return Fodselsnummer.parseSyntheticNumber(Fodselsnummer.parseDNumber(this.getValue())).substring(0, 2);
    }

    public String getMonth() {
        return Fodselsnummer.parseSyntheticNumber(Fodselsnummer.parseDNumber(this.getValue())).substring(2, 4);
    }

    public String getBirthYear() {
        return this.getCentury() + this.get2DigitBirthYear();
    }

    String getCentury() {
        String result = null;
        int individnummerInt = Integer.parseInt(this.getIndividnummer());
        int birthYear = Integer.parseInt(this.get2DigitBirthYear());
        if (Fodselsnummer.isDNumber(this.getValue())) {
            if (individnummerInt >= 500 && individnummerInt <= 599) {
                result = "18";
            } else if (individnummerInt <= 199 && birthYear < 40) {
                result = "19";
            } else if ((individnummerInt <= 499 || individnummerInt >= 600 && individnummerInt <= 999) && birthYear >= 40) {
                result = "19";
            } else if (individnummerInt >= 200 && individnummerInt <= 999 && birthYear < 40) {
                result = "20";
            }
        } else if (individnummerInt <= 499) {
            result = "19";
        } else if (individnummerInt >= 500 && birthYear < 40) {
            result = "20";
        } else if (individnummerInt >= 500 && individnummerInt <= 749 && birthYear >= 54) {
            result = "18";
        } else if (individnummerInt >= 900 && birthYear > 39) {
            result = "19";
        }
        return result;
    }

    public String get2DigitBirthYear() {
        return this.getValue().substring(4, 6);
    }

    public String getDateOfBirth() {
        return Fodselsnummer.parseSyntheticNumber(Fodselsnummer.parseDNumber(this.getValue())).substring(0, 6);
    }

    public String getPersonnummer() {
        return this.getValue().substring(6);
    }

    public String getIndividnummer() {
        return this.getValue().substring(6, 9);
    }

    public int getGenderDigit() {
        return this.getAt(8);
    }

    public int getChecksumDigit1() {
        return this.getAt(9);
    }

    public int getChecksumDigit2() {
        return this.getAt(10);
    }

    public boolean isMale() {
        return this.getGenderDigit() % 2 != 0;
    }

    public boolean isFemale() {
        return !this.isMale();
    }

    static String parseSyntheticNumber(String fodselsnummer) {
        if (!Fodselsnummer.isSynthetic(fodselsnummer)) {
            return fodselsnummer;
        }
        int monthNumber = Integer.parseInt(fodselsnummer.substring(2, 4));
        if (monthNumber >= 81 && monthNumber <= 92) {
            return fodselsnummer.substring(0, 2) + (Fodselsnummer.getThirdDigit(fodselsnummer) - 8) + fodselsnummer.substring(3);
        }
        if (monthNumber >= 66 && monthNumber <= 77) {
            String month = Integer.toString(monthNumber - 65);
            if (month.length() == 1) {
                month = "0" + month;
            }
            return fodselsnummer.substring(0, 2) + month + fodselsnummer.substring(4);
        }
        if (monthNumber >= 41 && monthNumber <= 52) {
            return fodselsnummer.substring(0, 2) + (Fodselsnummer.getThirdDigit(fodselsnummer) - 4) + fodselsnummer.substring(3);
        }
        throw new IllegalArgumentException(fodselsnummer + " is not a valid synthethic number");
    }

    static boolean isSynthetic(String fodselsnummer) {
        try {
            int monthNumber = Integer.parseInt(fodselsnummer.substring(2, 4));
            if (monthNumber >= 81 && monthNumber <= 92 || monthNumber >= 66 && monthNumber <= 77 || monthNumber >= 41 && monthNumber <= 52) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    static boolean isDNumber(String fodselsnummer) {
        try {
            int firstDigit = Fodselsnummer.getFirstDigit(fodselsnummer);
            if (firstDigit > 3 && firstDigit < 8) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    static String parseDNumber(String fodselsnummer) {
        if (!Fodselsnummer.isDNumber(fodselsnummer)) {
            return fodselsnummer;
        }
        return Fodselsnummer.getFirstDigit(fodselsnummer) - 4 + fodselsnummer.substring(1);
    }

    private static int getFirstDigit(String fodselsnummer) {
        return Integer.parseInt(fodselsnummer.substring(0, 1));
    }

    private static int getThirdDigit(String fodselsnummer) {
        return Integer.parseInt(fodselsnummer.substring(2, 3));
    }

    public KJONN getKjonn() {
        if (this.isFemale()) {
            return KJONN.KVINNE;
        }
        return KJONN.MANN;
    }

    @Override
    public String toString() {
        return super.getValue();
    }
}

