/*
 * Decompiled with CFR 0.152.
 */
package no.bekk.bekkopen.person;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import no.bekk.bekkopen.common.Checksums;
import no.bekk.bekkopen.common.StringNumberValidator;
import no.bekk.bekkopen.person.annotation.Fodselsnummer;

public class FodselsnummerValidator
extends StringNumberValidator
implements ConstraintValidator<Fodselsnummer, String> {
    private static final int LENGTH = 11;
    private static final String DATE_FORMAT = "ddMMyyyy";
    private static final int[] K1_WEIGHTS = new int[]{2, 5, 4, 9, 8, 1, 6, 7, 3};
    private static final int[] K2_WEIGHTS = new int[]{2, 3, 4, 5, 6, 7, 2, 3, 4, 5};
    protected static final String ERROR_INVALID_DATE = "Invalid date in f\u00f8dselsnummer : ";
    protected static final String ERROR_INVALID_INDIVIDNUMMER = "Invalid individnummer in f\u00f8dselsnummer : ";
    public static boolean ALLOW_SYNTHETIC_NUMBERS = false;

    public static no.bekk.bekkopen.person.Fodselsnummer getFodselsnummer(String fodselsnummer) throws IllegalArgumentException {
        FodselsnummerValidator.validateSyntax(fodselsnummer);
        FodselsnummerValidator.validateIndividnummer(fodselsnummer);
        FodselsnummerValidator.validateDate(fodselsnummer);
        FodselsnummerValidator.validateChecksums(fodselsnummer);
        FodselsnummerValidator.validateSynthetic(fodselsnummer);
        return new no.bekk.bekkopen.person.Fodselsnummer(fodselsnummer);
    }

    private static void validateSynthetic(String fodselsnummer) {
        if (no.bekk.bekkopen.person.Fodselsnummer.isSynthetic(fodselsnummer) && !ALLOW_SYNTHETIC_NUMBERS) {
            throw new IllegalArgumentException("Synthetic f\u00f8dselsnummer is not allowd" + fodselsnummer);
        }
    }

    public static boolean isValid(String fodselsnummer) {
        try {
            FodselsnummerValidator.getFodselsnummer(fodselsnummer);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static void validateSyntax(String fodselsnummer) {
        FodselsnummerValidator.validateLengthAndAllDigits(fodselsnummer, 11);
    }

    static void validateIndividnummer(String fodselsnummer) {
        no.bekk.bekkopen.person.Fodselsnummer fnr = new no.bekk.bekkopen.person.Fodselsnummer(fodselsnummer);
        if (fnr.getCentury() == null) {
            throw new IllegalArgumentException(ERROR_INVALID_INDIVIDNUMMER + fodselsnummer);
        }
    }

    static void validateDate(String fodselsnummer) {
        no.bekk.bekkopen.person.Fodselsnummer fnr = new no.bekk.bekkopen.person.Fodselsnummer(fodselsnummer);
        try {
            String dateString = fnr.getDateAndMonth() + fnr.getCentury() + fnr.get2DigitBirthYear();
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            df.setLenient(false);
            df.parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(ERROR_INVALID_DATE + fodselsnummer);
        }
    }

    static void validateChecksums(String fodselsnummer) {
        no.bekk.bekkopen.person.Fodselsnummer fnr = new no.bekk.bekkopen.person.Fodselsnummer(fodselsnummer);
        int k1 = FodselsnummerValidator.calculateFirstChecksumDigit(fnr);
        int k2 = FodselsnummerValidator.calculateSecondChecksumDigit(fnr);
        if (k1 != fnr.getChecksumDigit1() || k2 != fnr.getChecksumDigit2()) {
            throw new IllegalArgumentException("Invalid checksum : " + fodselsnummer);
        }
    }

    static int calculateFirstChecksumDigit(no.bekk.bekkopen.person.Fodselsnummer fodselsnummer) {
        return Checksums.calculateMod11CheckSum(K1_WEIGHTS, fodselsnummer);
    }

    static int calculateSecondChecksumDigit(no.bekk.bekkopen.person.Fodselsnummer fodselsnummer) {
        return Checksums.calculateMod11CheckSum(K2_WEIGHTS, fodselsnummer);
    }

    public void initialize(Fodselsnummer fodselsnummer) {
    }

    public boolean isValid(String fodselsnummer, ConstraintValidatorContext constraintValidatorContext) {
        if (fodselsnummer == null) {
            return true;
        }
        return FodselsnummerValidator.isValid(fodselsnummer);
    }

    static {
        URL flag = FodselsnummerValidator.class.getResource("/no.bekk.bekkopen.person.allow_synthetic_numbers.flag");
        if (flag != null) {
            ALLOW_SYNTHETIC_NUMBERS = true;
        }
    }
}

