package no.capraconsulting.siren;

/**
 * Class provides constants related to the Siren specification.
 *
 * @see <a href="https://github.com/kevinswiber/siren#entities">Siren specification</a>
 */
public final class Siren {
    private Siren() {}

    public static final String ACTIONS = "actions";
    public static final String APPLICATION_SIREN_JSON = "application/vnd.siren+json";
    public static final String CLASS = "class";
    public static final String ENTITIES = "entities";
    public static final String FIELDS = "fields";
    public static final String HREF = "href";
    public static final String LINKS = "links";
    public static final String METHOD = "method";
    public static final String NAME = "name";
    public static final String PROPERTIES = "properties";
    public static final String REL = "rel";
    public static final String SELF = "self";
    public static final String TITLE = "title";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
}
