/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import no.difi.asic.AsicVerifier;
import no.difi.asic.MessageDigestAlgorithm;
import no.difi.asic.SignatureMethod;

public class AsicVerifierFactory {
    private MessageDigestAlgorithm messageDigestAlgorithm;

    public static AsicVerifierFactory newFactory() {
        return AsicVerifierFactory.newFactory(MessageDigestAlgorithm.SHA256);
    }

    public static AsicVerifierFactory newFactory(SignatureMethod signatureMethod) {
        return AsicVerifierFactory.newFactory(signatureMethod.getMessageDigestAlgorithm());
    }

    static AsicVerifierFactory newFactory(MessageDigestAlgorithm messageDigestAlgorithm) {
        return new AsicVerifierFactory(messageDigestAlgorithm);
    }

    private AsicVerifierFactory(MessageDigestAlgorithm messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    public AsicVerifier verify(File file) throws IOException {
        return this.verify(file.toPath());
    }

    public AsicVerifier verify(Path file) throws IOException {
        return this.verify(Files.newInputStream(file, new OpenOption[0]));
    }

    public AsicVerifier verify(InputStream inputStream) throws IOException {
        return new AsicVerifier(this.messageDigestAlgorithm, inputStream);
    }
}

