/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import no.difi.asic.AbstractAsicManifest;
import no.difi.asic.ManifestVerifier;
import no.difi.asic.MessageDigestAlgorithm;
import no.difi.asic.MimeType;
import no.difi.commons.asic.jaxb.cades.ASiCManifestType;
import no.difi.commons.asic.jaxb.cades.DataObjectReferenceType;
import no.difi.commons.asic.jaxb.cades.ObjectFactory;
import no.difi.commons.asic.jaxb.cades.SigReferenceType;
import no.difi.commons.asic.jaxb.xmldsig.DigestMethodType;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CadesAsicManifest
extends AbstractAsicManifest {
    public static final Logger logger = LoggerFactory.getLogger(AbstractAsicManifest.class);
    private static JAXBContext jaxbContext;
    private static ObjectFactory objectFactory;
    private ASiCManifestType ASiCManifestType = new ASiCManifestType();
    private boolean rootFilenameIsSet = false;

    public CadesAsicManifest(MessageDigestAlgorithm messageDigestAlgorithm) {
        super(messageDigestAlgorithm);
    }

    @Override
    public void add(String filename, MimeType mimeType) {
        DataObjectReferenceType dataObject = new DataObjectReferenceType();
        dataObject.setURI(filename);
        dataObject.setMimeType(mimeType.toString());
        dataObject.setDigestValue(this.messageDigest.digest());
        DigestMethodType digestMethodType = new DigestMethodType();
        digestMethodType.setAlgorithm(this.messageDigestAlgorithm.getUri());
        dataObject.setDigestMethod(digestMethodType);
        this.ASiCManifestType.getDataObjectReference().add(dataObject);
        logger.debug("Digest: {}", (Object)Base64.encode((byte[])dataObject.getDigestValue()));
    }

    public void setRootfileForEntry(String entryName) {
        if (this.rootFilenameIsSet) {
            throw new IllegalStateException("Multiple root files are not allowed.");
        }
        for (DataObjectReferenceType dataObject : this.ASiCManifestType.getDataObjectReference()) {
            if (!dataObject.getURI().equals(entryName)) continue;
            dataObject.setRootfile(true);
            this.rootFilenameIsSet = true;
            return;
        }
    }

    public void setSignature(String filename, String mimeType) {
        SigReferenceType sigReferenceType = new SigReferenceType();
        sigReferenceType.setURI(filename);
        sigReferenceType.setMimeType(mimeType);
        this.ASiCManifestType.setSigReference(sigReferenceType);
    }

    public ASiCManifestType getASiCManifestType() {
        return this.ASiCManifestType;
    }

    public byte[] toBytes() {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal(objectFactory.createASiCManifest(this.ASiCManifestType), (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to marshall the ASiCManifest into string output", e);
        }
    }

    public static String extractAndVerify(String xml, ManifestVerifier manifestVerifier) {
        xml = xml.replace("http://uri.etsi.org/02918/v1.1.1#", "http://uri.etsi.org/02918/v1.2.1#");
        xml = xml.replace("http://uri.etsi.org/2918/v1.2.1#", "http://uri.etsi.org/02918/v1.2.1#");
        xml = xml.replaceAll("http://www.w3.org/2000/09/xmldsig#sha", "http://www.w3.org/2001/04/xmlenc#sha");
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ASiCManifestType manifest = (ASiCManifestType)((JAXBElement)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()))).getValue();
            String sigReference = manifest.getSigReference().getURI();
            if (sigReference == null) {
                sigReference = "META-INF/signature.p7s";
            }
            for (DataObjectReferenceType reference : manifest.getDataObjectReference()) {
                manifestVerifier.update(reference.getURI(), reference.getMimeType(), reference.getDigestValue(), reference.getDigestMethod().getAlgorithm(), sigReference);
                if (reference.isRootfile() != Boolean.TRUE) continue;
                manifestVerifier.setRootFilename(reference.getURI());
            }
            return sigReference;
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to read content as XML", e);
        }
    }

    static {
        objectFactory = new ObjectFactory();
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ASiCManifestType.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException(String.format("Unable to create JAXBContext: %s ", e.getMessage()), e);
        }
    }
}

