/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import no.difi.asic.BCHelper;
import no.difi.asic.KeyStoreType;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureHelper {
    private static final Logger logger = LoggerFactory.getLogger(SignatureHelper.class);
    public static final KeyStoreType DEFAULT_KEY_STORE_TYPE = KeyStoreType.JKS;
    protected final Provider provider;
    protected final JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder;
    protected X509Certificate x509Certificate;
    protected Certificate[] certificateChain;
    protected KeyPair keyPair;
    protected JcaContentSignerBuilder jcaContentSignerBuilder;

    public SignatureHelper(File keyStoreFile, String keyStorePassword, String keyPassword) throws IOException {
        this(keyStoreFile, keyStorePassword, null, keyPassword);
    }

    public SignatureHelper(File keyStoreFile, String keyStorePassword, String keyAlias, String keyPassword) throws IOException {
        this(keyStoreFile, keyStorePassword, DEFAULT_KEY_STORE_TYPE, keyAlias, keyPassword);
    }

    public SignatureHelper(InputStream keyStoreStream, String keyStorePassword, String keyAlias, String keyPassword) {
        this(keyStoreStream, keyStorePassword, DEFAULT_KEY_STORE_TYPE, keyAlias, keyPassword);
    }

    public SignatureHelper(File keyStoreFile, String keyStorePassword, KeyStoreType keyStoreType, String keyAlias, String keyPassword) throws IOException {
        this(BCHelper.getProvider());
        try (InputStream inputStream = Files.newInputStream(keyStoreFile.toPath(), new OpenOption[0]);){
            this.loadCertificate(this.loadKeyStore(inputStream, keyStorePassword, keyStoreType), keyAlias, keyPassword);
        }
    }

    public SignatureHelper(InputStream keyStoreStream, String keyStorePassword, KeyStoreType keyStoreType, String keyAlias, String keyPassword) {
        this(BCHelper.getProvider());
        this.loadCertificate(this.loadKeyStore(keyStoreStream, keyStorePassword, keyStoreType), keyAlias, keyPassword);
    }

    protected SignatureHelper(Provider provider) {
        this.provider = provider;
        this.jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();
        if (provider != null) {
            this.jcaDigestCalculatorProviderBuilder.setProvider(provider);
        }
    }

    protected KeyStore loadKeyStore(InputStream keyStoreStream, String keyStorePassword, KeyStoreType keyStoreType) {
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.name());
            keyStore.load(keyStoreStream, keyStorePassword.toCharArray());
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Load keystore; %s", e.getMessage()), e);
        }
    }

    protected void loadCertificate(KeyStore keyStore, String keyAlias, String keyPassword) {
        try {
            if (keyAlias == null) {
                keyAlias = keyStore.aliases().nextElement();
            }
            this.x509Certificate = (X509Certificate)keyStore.getCertificate(keyAlias);
            this.certificateChain = keyStore.getCertificateChain(keyAlias);
            Key key = keyStore.getKey(keyAlias, keyPassword.toCharArray());
            PrivateKey privateKey = (PrivateKey)key;
            this.keyPair = new KeyPair(this.x509Certificate.getPublicKey(), privateKey);
            this.jcaContentSignerBuilder = new JcaContentSignerBuilder(String.format("SHA1with%s", privateKey.getAlgorithm()));
            if (this.provider != null) {
                this.jcaContentSignerBuilder.setProvider(this.provider);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to retrieve private key from keystore: %s", e.getMessage()), e);
        }
    }

    byte[] signData(byte[] data) {
        try {
            DigestCalculatorProvider digestCalculatorProvider = this.jcaDigestCalculatorProviderBuilder.build();
            ContentSigner contentSigner = this.jcaContentSignerBuilder.build(this.keyPair.getPrivate());
            SignerInfoGenerator signerInfoGenerator = new JcaSignerInfoGeneratorBuilder(digestCalculatorProvider).build(contentSigner, this.x509Certificate);
            CMSSignedDataGenerator cmsSignedDataGenerator = new CMSSignedDataGenerator();
            cmsSignedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
            cmsSignedDataGenerator.addCertificates((Store)new JcaCertStore(Arrays.asList(this.certificateChain)));
            CMSSignedData cmsSignedData = cmsSignedDataGenerator.generate((CMSTypedData)new CMSProcessableByteArray(data), false);
            logger.debug(BaseEncoding.base64().encode(cmsSignedData.getEncoded()));
            return cmsSignedData.getEncoded();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to sign: %s", e.getMessage()), e);
        }
    }

    X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    Certificate[] getCertificateChain() {
        return this.certificateChain;
    }
}

