/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import no.difi.asic.AbstractAsicManifest;
import no.difi.asic.ManifestVerifier;
import no.difi.asic.MessageDigestAlgorithm;
import no.difi.asic.MimeType;
import no.difi.asic.SignatureHelper;
import no.difi.commons.asic.jaxb.cades.XAdESSignaturesType;
import no.difi.commons.asic.jaxb.xades.CertIDListType;
import no.difi.commons.asic.jaxb.xades.CertIDType;
import no.difi.commons.asic.jaxb.xades.DataObjectFormatType;
import no.difi.commons.asic.jaxb.xades.DigestAlgAndValueType;
import no.difi.commons.asic.jaxb.xades.ObjectFactory;
import no.difi.commons.asic.jaxb.xades.QualifyingPropertiesType;
import no.difi.commons.asic.jaxb.xades.SignedDataObjectPropertiesType;
import no.difi.commons.asic.jaxb.xades.SignedPropertiesType;
import no.difi.commons.asic.jaxb.xades.SignedSignaturePropertiesType;
import no.difi.commons.asic.jaxb.xmldsig.CanonicalizationMethodType;
import no.difi.commons.asic.jaxb.xmldsig.DigestMethodType;
import no.difi.commons.asic.jaxb.xmldsig.KeyInfoType;
import no.difi.commons.asic.jaxb.xmldsig.ObjectType;
import no.difi.commons.asic.jaxb.xmldsig.ReferenceType;
import no.difi.commons.asic.jaxb.xmldsig.SignatureMethodType;
import no.difi.commons.asic.jaxb.xmldsig.SignatureType;
import no.difi.commons.asic.jaxb.xmldsig.SignatureValueType;
import no.difi.commons.asic.jaxb.xmldsig.SignedInfoType;
import no.difi.commons.asic.jaxb.xmldsig.TransformType;
import no.difi.commons.asic.jaxb.xmldsig.TransformsType;
import no.difi.commons.asic.jaxb.xmldsig.X509DataType;
import no.difi.commons.asic.jaxb.xmldsig.X509IssuerSerialType;

class XadesAsicManifest
extends AbstractAsicManifest {
    private static JAXBContext jaxbContext;
    private static ObjectFactory objectFactory1_2;
    private static no.difi.commons.asic.jaxb.cades.ObjectFactory objectFactory1_3;
    private SignedInfoType signedInfo;
    private SignedDataObjectPropertiesType signedDataObjectProperties = new SignedDataObjectPropertiesType();

    public XadesAsicManifest(MessageDigestAlgorithm messageDigestAlgorithm) {
        super(messageDigestAlgorithm);
        this.signedInfo = new SignedInfoType();
        CanonicalizationMethodType canonicalizationMethod = new CanonicalizationMethodType();
        canonicalizationMethod.setAlgorithm("http://www.w3.org/2006/12/xml-c14n11");
        this.signedInfo.setCanonicalizationMethod(canonicalizationMethod);
        SignatureMethodType signatureMethod = new SignatureMethodType();
        signatureMethod.setAlgorithm(messageDigestAlgorithm.getUri());
        this.signedInfo.setSignatureMethod(signatureMethod);
    }

    @Override
    public void add(String filename, MimeType mimeType) {
        String id = String.format("ID_%s", this.signedInfo.getReference().size());
        ReferenceType reference = new ReferenceType();
        reference.setId(id);
        reference.setURI(filename);
        reference.setDigestValue(this.messageDigest.digest());
        DigestMethodType digestMethodType = new DigestMethodType();
        digestMethodType.setAlgorithm(this.messageDigestAlgorithm.getUri());
        reference.setDigestMethod(digestMethodType);
        this.signedInfo.getReference().add(reference);
        DataObjectFormatType dataObjectFormatType = new DataObjectFormatType();
        dataObjectFormatType.setObjectReference(String.format("#%s", id));
        dataObjectFormatType.setMimeType(mimeType.toString());
        this.signedDataObjectProperties.getDataObjectFormat().add(dataObjectFormatType);
    }

    XAdESSignaturesType getCreateXAdESSignatures(SignatureHelper signatureHelper) {
        XAdESSignaturesType xAdESSignaturesType = new XAdESSignaturesType();
        SignatureType signatureType = new SignatureType();
        signatureType.setId("Signature");
        signatureType.setSignedInfo(this.signedInfo);
        xAdESSignaturesType.getSignature().add(signatureType);
        KeyInfoType keyInfoType = new KeyInfoType();
        keyInfoType.getContent().add(this.getX509Data(signatureHelper));
        signatureType.setKeyInfo(keyInfoType);
        ObjectType objectType = new ObjectType();
        objectType.getContent().add(this.getQualifyingProperties(signatureHelper));
        signatureType.getObject().add(objectType);
        signatureType.setSignatureValue(this.getSignature());
        return xAdESSignaturesType;
    }

    public byte[] toBytes(SignatureHelper signatureHelper) {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal(objectFactory1_3.createXAdESSignatures(this.getCreateXAdESSignatures(signatureHelper)), (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to marshall the XAdESSignature into string output", e);
        }
    }

    private JAXBElement<X509DataType> getX509Data(SignatureHelper signatureHelper) {
        no.difi.commons.asic.jaxb.xmldsig.ObjectFactory objectFactory = new no.difi.commons.asic.jaxb.xmldsig.ObjectFactory();
        X509DataType x509DataType = new X509DataType();
        for (Certificate certificate : signatureHelper.getCertificateChain()) {
            try {
                x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(objectFactory.createX509DataTypeX509Certificate(certificate.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                throw new IllegalStateException("Unable to insert certificate.", e);
            }
        }
        return objectFactory.createX509Data(x509DataType);
    }

    private JAXBElement<QualifyingPropertiesType> getQualifyingProperties(SignatureHelper signatureHelper) {
        SignedSignaturePropertiesType signedSignaturePropertiesType = new SignedSignaturePropertiesType();
        try {
            signedSignaturePropertiesType.setSigningTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Unable to use current DatatypeFactory", e);
        }
        CertIDListType certIDListType = new CertIDListType();
        signedSignaturePropertiesType.setSigningCertificate(certIDListType);
        CertIDType cert = new CertIDType();
        certIDListType.getCert().add(cert);
        try {
            DigestAlgAndValueType certDigest = new DigestAlgAndValueType();
            certDigest.setDigestValue(Hashing.sha1().hashBytes(signatureHelper.getX509Certificate().getEncoded()).asBytes());
            cert.setCertDigest(certDigest);
            DigestMethodType digestMethodType = new DigestMethodType();
            digestMethodType.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
            certDigest.setDigestMethod(digestMethodType);
        }
        catch (CertificateEncodingException e) {
            throw new IllegalStateException("Unable to encode certificate.", e);
        }
        X509IssuerSerialType issuerSerialType = new X509IssuerSerialType();
        issuerSerialType.setX509IssuerName(signatureHelper.getX509Certificate().getIssuerX500Principal().getName());
        issuerSerialType.setX509SerialNumber(signatureHelper.getX509Certificate().getSerialNumber());
        cert.setIssuerSerial(issuerSerialType);
        SignedPropertiesType signedPropertiesType = new SignedPropertiesType();
        signedPropertiesType.setId("SignedProperties");
        signedPropertiesType.setSignedSignatureProperties(signedSignaturePropertiesType);
        signedPropertiesType.setSignedDataObjectProperties(this.signedDataObjectProperties);
        QualifyingPropertiesType qualifyingPropertiesType = new QualifyingPropertiesType();
        qualifyingPropertiesType.setTarget("#Signature");
        ReferenceType reference = new ReferenceType();
        reference.setType("http://uri.etsi.org/01903#SignedProperties");
        reference.setURI("#SignedProperties");
        TransformsType transformsType = new TransformsType();
        reference.setTransforms(transformsType);
        TransformType transformType = new TransformType();
        transformType.setAlgorithm("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        reference.getTransforms().getTransform().add(transformType);
        DigestMethodType digestMethodType = new DigestMethodType();
        digestMethodType.setAlgorithm(this.messageDigestAlgorithm.getUri());
        reference.setDigestMethod(digestMethodType);
        this.signedInfo.getReference().add(reference);
        return objectFactory1_2.createQualifyingProperties(qualifyingPropertiesType);
    }

    protected SignatureValueType getSignature() {
        return new SignatureValueType();
    }

    public static void extractAndVerify(String xml, ManifestVerifier manifestVerifier) {
        XAdESSignaturesType manifest;
        xml = xml.replace("http://uri.etsi.org/02918/v1.1.1#", "http://uri.etsi.org/02918/v1.2.1#");
        xml = xml.replace("http://uri.etsi.org/2918/v1.2.1#", "http://uri.etsi.org/02918/v1.2.1#");
        xml = xml.replaceAll("http://www.w3.org/2000/09/xmldsig#sha", "http://www.w3.org/2001/04/xmlenc#sha");
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            manifest = (XAdESSignaturesType)unmarshaller.unmarshal((Source)new StreamSource(new ByteArrayInputStream(xml.getBytes())), XAdESSignaturesType.class).getValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read content as XML", e);
        }
        for (SignatureType signature : manifest.getSignature()) {
            SignedInfoType signedInfoType = signature.getSignedInfo();
            for (ReferenceType reference : signedInfoType.getReference()) {
                if (reference.getURI().startsWith("#")) continue;
                manifestVerifier.update(reference.getURI(), null, reference.getDigestValue(), reference.getDigestMethod().getAlgorithm(), null);
            }
        }
    }

    static {
        objectFactory1_2 = new ObjectFactory();
        objectFactory1_3 = new no.difi.commons.asic.jaxb.cades.ObjectFactory();
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XAdESSignaturesType.class, X509DataType.class, QualifyingPropertiesType.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException(String.format("Unable to create JAXBContext: %s ", e.getMessage()), e);
        }
    }
}

