/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import no.difi.certvalidator.ValidatorGroup;
import no.difi.certvalidator.ValidatorLoaderParser;
import no.difi.certvalidator.lang.ValidatorParsingException;

public class ValidatorLoader {
    private Map<String, Object> objectStorage = new HashMap<String, Object>();

    public static ValidatorLoader newInstance() {
        return new ValidatorLoader();
    }

    private ValidatorLoader() {
    }

    public ValidatorLoader put(String key, Object value) {
        this.objectStorage.put(key, value);
        return this;
    }

    public ValidatorLoader putAll(Map<String, Object> values) {
        if (values != null) {
            this.objectStorage.putAll(values);
        }
        return this;
    }

    public ValidatorGroup build(Path path) throws IOException, ValidatorParsingException {
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        ValidatorGroup validatorGroup = this.build(inputStream);
        inputStream.close();
        return validatorGroup;
    }

    public ValidatorGroup build(InputStream inputStream) throws ValidatorParsingException {
        return ValidatorLoaderParser.parse(inputStream, new HashMap<String, Object>(this.objectStorage));
    }
}

