/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.rule.AbstractRule;

public class CriticalExtensionRequiredRule
extends AbstractRule {
    private List<String> requiredExtensions;

    public CriticalExtensionRequiredRule(String ... requiredExtensions) {
        this.requiredExtensions = Arrays.asList(requiredExtensions);
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        Set<String> oids = certificate.getCriticalExtensionOIDs();
        if (oids == null) {
            throw new FailedValidationException("Certificate doesn't contain critical OIDs.");
        }
        for (String oid : this.requiredExtensions) {
            if (oids.contains(oid)) continue;
            throw new FailedValidationException(String.format("Certificate doesn't contain critical OID '%s'.", oid));
        }
    }
}

