/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.cert.X509Certificate;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.rule.AbstractRule;

public class ExpirationSoonRule
extends AbstractRule {
    private long millis;

    public ExpirationSoonRule(long millis) {
        this.millis = millis;
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        if (certificate.getNotAfter().getTime() < System.currentTimeMillis() + this.millis) {
            throw new FailedValidationException(String.format("Certificate expires in less than %s milliseconds.", this.millis));
        }
    }
}

