/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.Property;
import no.difi.certvalidator.api.Report;
import no.difi.certvalidator.rule.AbstractRule;
import no.difi.certvalidator.util.SimpleProperty;

public class SigningRule
extends AbstractRule {
    public static final Property<Kind> KIND = SimpleProperty.create();
    private final Kind kind;

    public static SigningRule PublicSignedOnly() {
        return new SigningRule(Kind.PUBLIC_SIGNED_ONLY);
    }

    public static SigningRule SelfSignedOnly() {
        return new SigningRule(Kind.SELF_SIGNED_ONLY);
    }

    public SigningRule() {
        this(Kind.PUBLIC_SIGNED_ONLY);
    }

    public SigningRule(Kind kind) {
        this.kind = kind;
    }

    @Override
    public Report validate(X509Certificate certificate, Report report) throws CertificateValidationException {
        try {
            if (SigningRule.isSelfSigned(certificate)) {
                if (this.kind.equals((Object)Kind.PUBLIC_SIGNED_ONLY)) {
                    throw new FailedValidationException("Certificate should be publicly signed.");
                }
            } else if (this.kind.equals((Object)Kind.SELF_SIGNED_ONLY)) {
                throw new FailedValidationException("Certificate should be self-signed.");
            }
            report.set(KIND, this.kind);
            return report;
        }
        catch (FailedValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
    }

    public static boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (InvalidKeyException | SignatureException e) {
            return false;
        }
    }

    public static enum Kind {
        PUBLIC_SIGNED_ONLY,
        SELF_SIGNED_ONLY;

    }
}

