/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.util;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.security.auth.x500.X500Principal;
import no.difi.certvalidator.api.CertificateBucket;
import no.difi.certvalidator.api.CertificateBucketException;
import no.difi.certvalidator.util.SimpleCertificateBucket;

public class KeyStoreCertificateBucket
implements CertificateBucket {
    protected KeyStore keyStore;

    public KeyStoreCertificateBucket(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public KeyStoreCertificateBucket(InputStream inputStream, String password) throws CertificateBucketException {
        this("JKS", inputStream, password);
    }

    public KeyStoreCertificateBucket(String type, InputStream inputStream, String password) throws CertificateBucketException {
        try {
            this.keyStore = KeyStore.getInstance(type);
            this.keyStore.load(inputStream, password.toCharArray());
            inputStream.close();
        }
        catch (Exception e) {
            throw new CertificateBucketException(e.getMessage(), e);
        }
    }

    @Override
    public X509Certificate findBySubject(X500Principal principal) throws CertificateBucketException {
        for (X509Certificate certificate : this) {
            if (!certificate.getSubjectX500Principal().equals(principal)) continue;
            return certificate;
        }
        return null;
    }

    @Override
    public Iterator<X509Certificate> iterator() {
        try {
            final KeyStore keyStore = this.getKeyStore();
            final Enumeration<String> aliases = keyStore.aliases();
            return new Iterator<X509Certificate>(){

                @Override
                public boolean hasNext() {
                    return aliases.hasMoreElements();
                }

                @Override
                public X509Certificate next() {
                    try {
                        return (X509Certificate)keyStore.getCertificate((String)aliases.nextElement());
                    }
                    catch (KeyStoreException | NoSuchElementException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }

                @Override
                public void remove() {
                }
            };
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void toSimple(SimpleCertificateBucket certificates, String ... aliases) throws CertificateBucketException {
        try {
            List<String> aliasesList = Arrays.asList(aliases);
            KeyStore keyStore = this.getKeyStore();
            Enumeration<String> aliasesEnumeration = keyStore.aliases();
            while (aliasesEnumeration.hasMoreElements()) {
                String alias = aliasesEnumeration.nextElement();
                if (!aliasesList.contains(alias)) continue;
                certificates.add((X509Certificate)keyStore.getCertificate(alias));
            }
        }
        catch (Exception e) {
            throw new CertificateBucketException(e.getMessage(), e);
        }
    }

    public SimpleCertificateBucket toSimple(String ... aliases) throws CertificateBucketException {
        SimpleCertificateBucket certificates = new SimpleCertificateBucket(new X509Certificate[0]);
        this.toSimple(certificates, aliases);
        return certificates;
    }

    public void startsWith(SimpleCertificateBucket certificates, String ... prefix) throws CertificateBucketException {
        try {
            KeyStore keyStore = this.getKeyStore();
            Enumeration<String> aliasesEnumeration = keyStore.aliases();
            while (aliasesEnumeration.hasMoreElements()) {
                String alias = aliasesEnumeration.nextElement();
                for (String p : prefix) {
                    if (!alias.startsWith(p)) continue;
                    certificates.add((X509Certificate)keyStore.getCertificate(alias));
                }
            }
        }
        catch (Exception e) {
            throw new CertificateBucketException(e.getMessage(), e);
        }
    }

    public SimpleCertificateBucket startsWith(String ... prefix) throws CertificateBucketException {
        SimpleCertificateBucket certificates = new SimpleCertificateBucket(new X509Certificate[0]);
        this.startsWith(certificates, prefix);
        return certificates;
    }

    protected KeyStore getKeyStore() throws CertificateBucketException {
        return this.keyStore;
    }
}

