/*
 * Decompiled with CFR 0.152.
 */
package no.difi.oxalis.sniffer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import no.difi.oxalis.sniffer.identifier.InstanceId;
import no.difi.oxalis.sniffer.identifier.PeppolDocumentTypeId;
import no.difi.vefa.peppol.common.model.DocumentTypeIdentifier;
import no.difi.vefa.peppol.common.model.Header;
import no.difi.vefa.peppol.common.model.InstanceIdentifier;
import no.difi.vefa.peppol.common.model.InstanceType;
import no.difi.vefa.peppol.common.model.ParticipantIdentifier;
import no.difi.vefa.peppol.common.model.ProcessIdentifier;

public class PeppolStandardBusinessHeader {
    private ParticipantIdentifier recipientId;
    private ParticipantIdentifier senderId;
    private DocumentTypeIdentifier peppolDocumentTypeId;
    private ProcessIdentifier profileTypeIdentifier;
    private InstanceId instanceId;
    private Date creationDateAndTime;

    public static PeppolStandardBusinessHeader createPeppolStandardBusinessHeaderWithNewDate() {
        PeppolStandardBusinessHeader p = new PeppolStandardBusinessHeader();
        p.setCreationDateAndTime(new Date());
        return p;
    }

    public PeppolStandardBusinessHeader() {
    }

    public PeppolStandardBusinessHeader(Header header) {
        this.senderId = header.getSender();
        this.recipientId = header.getReceiver();
        this.creationDateAndTime = header.getCreationTimestamp();
        this.peppolDocumentTypeId = header.getDocumentType();
        this.profileTypeIdentifier = header.getProcess();
        this.instanceId = new InstanceId(header.getIdentifier().getIdentifier());
    }

    public PeppolStandardBusinessHeader(PeppolStandardBusinessHeader peppolStandardBusinessHeader) {
        this.recipientId = peppolStandardBusinessHeader.getRecipientId();
        this.senderId = peppolStandardBusinessHeader.getSenderId();
        this.peppolDocumentTypeId = peppolStandardBusinessHeader.getDocumentTypeIdentifier();
        this.profileTypeIdentifier = peppolStandardBusinessHeader.getProfileTypeIdentifier();
        this.instanceId = peppolStandardBusinessHeader.getInstanceId();
        this.creationDateAndTime = peppolStandardBusinessHeader.getCreationDateAndTime();
    }

    public boolean isComplete() {
        return this.recipientId != null && this.senderId != null && this.peppolDocumentTypeId != null && this.profileTypeIdentifier != null && this.instanceId != null && this.creationDateAndTime != null;
    }

    public List<String> listMissingProperties() {
        ArrayList<String> mhf = new ArrayList<String>();
        if (this.recipientId == null) {
            mhf.add("recipientId");
        }
        if (this.senderId == null) {
            mhf.add("senderId");
        }
        if (this.peppolDocumentTypeId == null) {
            mhf.add("peppolDocumentTypeId");
        }
        if (this.profileTypeIdentifier == null) {
            mhf.add("profileTypeIdentifier");
        }
        if (this.instanceId == null) {
            mhf.add("messageId");
        }
        if (this.creationDateAndTime == null) {
            mhf.add("creationDateAndTime");
        }
        return mhf;
    }

    public void setRecipientId(ParticipantIdentifier recipientId) {
        this.recipientId = recipientId;
    }

    public ParticipantIdentifier getRecipientId() {
        return this.recipientId;
    }

    public void setSenderId(ParticipantIdentifier senderId) {
        this.senderId = senderId;
    }

    public ParticipantIdentifier getSenderId() {
        return this.senderId;
    }

    public void setInstanceId(InstanceId instanceId) {
        this.instanceId = instanceId;
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public void setCreationDateAndTime(Date creationDateAndTime) {
        this.creationDateAndTime = creationDateAndTime;
    }

    public Date getCreationDateAndTime() {
        return this.creationDateAndTime;
    }

    @Deprecated
    public void setDocumentTypeIdentifier(PeppolDocumentTypeId documentTypeIdentifier) {
        this.setDocumentTypeIdentifier(documentTypeIdentifier.toVefa());
    }

    public void setDocumentTypeIdentifier(DocumentTypeIdentifier documentTypeIdentifier) {
        this.peppolDocumentTypeId = documentTypeIdentifier;
    }

    public DocumentTypeIdentifier getDocumentTypeIdentifier() {
        return this.peppolDocumentTypeId;
    }

    public void setProfileTypeIdentifier(ProcessIdentifier processIdentifier) {
        this.profileTypeIdentifier = processIdentifier;
    }

    public ProcessIdentifier getProfileTypeIdentifier() {
        return this.profileTypeIdentifier;
    }

    public Header toVefa() {
        PeppolDocumentTypeId documentTypeId = PeppolDocumentTypeId.valueOf(this.peppolDocumentTypeId.getIdentifier());
        return Header.of((ParticipantIdentifier)this.senderId, (ParticipantIdentifier)this.recipientId, (ProcessIdentifier)this.profileTypeIdentifier, (DocumentTypeIdentifier)this.peppolDocumentTypeId, (InstanceIdentifier)(this.instanceId == null ? InstanceIdentifier.generateUUID() : this.instanceId.toVefa()), (InstanceType)InstanceType.of((String)documentTypeId.getRootNameSpace(), (String)documentTypeId.getLocalName(), (String)documentTypeId.getVersion()), (Date)this.creationDateAndTime);
    }
}

