/*
 * Decompiled with CFR 0.152.
 */
package no.difi.oxalis.sniffer.document;

import javax.xml.xpath.XPath;
import no.difi.oxalis.sniffer.document.PlainUBLParser;
import no.difi.oxalis.sniffer.document.parsers.ApplicationResponseDocumentParser;
import no.difi.oxalis.sniffer.document.parsers.CatalogueDocumentParser;
import no.difi.oxalis.sniffer.document.parsers.DespatchAdviceDocumentParser;
import no.difi.oxalis.sniffer.document.parsers.InvoiceDocumentParser;
import no.difi.oxalis.sniffer.document.parsers.OrderDocumentParser;
import no.difi.oxalis.sniffer.document.parsers.PEPPOLDocumentParser;
import no.difi.oxalis.sniffer.identifier.CustomizationIdentifier;
import no.difi.oxalis.sniffer.identifier.PeppolDocumentTypeId;
import no.difi.vefa.peppol.common.model.ProcessIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PlainUBLHeaderParser
extends PlainUBLParser {
    public static final Logger log = LoggerFactory.getLogger(PlainUBLHeaderParser.class);

    public PlainUBLHeaderParser(Document document, XPath xPath) {
        super(document, xPath);
    }

    public CustomizationIdentifier fetchCustomizationId() {
        String value = this.retriveValueForXpath("//cbc:CustomizationID");
        return CustomizationIdentifier.valueOf(value);
    }

    public ProcessIdentifier fetchProcessTypeId() {
        String value = this.retriveValueForXpath("//cbc:ProfileID");
        return ProcessIdentifier.of((String)value);
    }

    public PeppolDocumentTypeId fetchDocumentTypeId() {
        CustomizationIdentifier customizationIdentifier = this.fetchCustomizationId();
        return new PeppolDocumentTypeId(this.rootNameSpace(), this.localName(), customizationIdentifier, this.ublVersion());
    }

    public PEPPOLDocumentParser createDocumentParser() {
        String type = this.localName();
        log.debug("Creating DocumentParser for type : " + this.localName());
        if ("DespatchAdvice".equalsIgnoreCase(type)) {
            return new DespatchAdviceDocumentParser(this);
        }
        if ("Catalogue".equalsIgnoreCase(type)) {
            return new CatalogueDocumentParser(this);
        }
        if ("CreditNote".equalsIgnoreCase(type)) {
            return new InvoiceDocumentParser(this);
        }
        if ("Invoice".equalsIgnoreCase(type)) {
            return new InvoiceDocumentParser(this);
        }
        if ("Reminder".equalsIgnoreCase(type)) {
            return new InvoiceDocumentParser(this);
        }
        if ("Order".equalsIgnoreCase(type)) {
            return new OrderDocumentParser(this);
        }
        if ("OrderResponse".equalsIgnoreCase(type)) {
            return new OrderDocumentParser(this);
        }
        if ("OrderResponseSimple".equalsIgnoreCase(type)) {
            return new OrderDocumentParser(this);
        }
        if ("ApplicationResponse".equalsIgnoreCase(type)) {
            return new ApplicationResponseDocumentParser(this);
        }
        throw new IllegalStateException("Cannot decide which PEPPOLDocumentParser to use for type " + type);
    }
}

