/*
 * Decompiled with CFR 0.152.
 */
package no.difi.vefa.peppol.common.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public interface Period {
    public Date getFrom();

    public Date getTo();

    default public boolean isCurrent(Date date) {
        return date.after(this.getFrom()) && date.before(this.getTo());
    }

    default public boolean isCurrent() {
        return this.isCurrent(new Date());
    }

    public static Period of(Date from, Date to) {
        return new DefaultPeriod(from, to);
    }

    public static class DefaultPeriod
    implements Period,
    Serializable {
        private static final long serialVersionUID = 888582195965219162L;
        private Date from;
        private Date to;

        private DefaultPeriod(Date from, Date to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Period period = (Period)o;
            return Objects.equals(this.from, period.getFrom()) && Objects.equals(this.to, period.getTo());
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }

        @Override
        public Date getFrom() {
            return this.from;
        }

        @Override
        public Date getTo() {
            return this.to;
        }

        public String toString() {
            return "Period.DefaultPeriod(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }
    }
}

