/*
 * Decompiled with CFR 0.152.
 */
package no.difi.vefa.peppol.common.model;

import java.io.Serializable;
import no.difi.vefa.peppol.common.lang.PeppolParsingException;
import no.difi.vefa.peppol.common.model.AbstractQualifiedIdentifier;
import no.difi.vefa.peppol.common.model.Scheme;

public class ProcessIdentifier
extends AbstractQualifiedIdentifier
implements Serializable {
    private static final long serialVersionUID = 7486398061021950763L;
    public static final Scheme DEFAULT_SCHEME = Scheme.of("cenbii-procid-ubl");
    public static final ProcessIdentifier NO_PROCESS = ProcessIdentifier.of("bdx:noprocess", Scheme.of("bdx-procid-transport"));

    public static ProcessIdentifier of(String identifier) {
        return new ProcessIdentifier(identifier, DEFAULT_SCHEME);
    }

    public static ProcessIdentifier of(String identifier, Scheme scheme) {
        return new ProcessIdentifier(identifier, scheme);
    }

    public static ProcessIdentifier parse(String str) throws PeppolParsingException {
        String[] parts = str.split("::", 2);
        if (parts.length != 2) {
            throw new PeppolParsingException(String.format("Unable to parse process identifier '%s'.", str));
        }
        return ProcessIdentifier.of(parts[1], Scheme.of(parts[0]));
    }

    private ProcessIdentifier(String value, Scheme scheme) {
        super(value, scheme);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessIdentifier that = (ProcessIdentifier)o;
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        return this.scheme.equals(that.scheme);
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = 31 * result + this.scheme.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s::%s", this.scheme, this.identifier);
    }
}

