/*
 * Decompiled with CFR 0.152.
 */
package no.difi.vefa.peppol.common.model;

import java.io.Serializable;
import java.util.Arrays;

public class Receipt
implements Serializable {
    private static final long serialVersionUID = -2334768925814974368L;
    private final String type;
    private final byte[] value;

    public static Receipt of(String type, byte[] value) {
        return new Receipt(type, value);
    }

    public static Receipt of(byte[] value) {
        return Receipt.of(null, value);
    }

    private Receipt(String type, byte[] value) {
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Receipt receipt = (Receipt)o;
        if (this.type != null ? !this.type.equals(receipt.type) : receipt.type != null) {
            return false;
        }
        return Arrays.equals(this.value, receipt.value);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public String toString() {
        return "Receipt{type='" + this.type + '\'' + ", value=" + Arrays.toString(this.value) + '}';
    }
}

