/*
 * Decompiled with CFR 0.152.
 */
package no.difi.vefa.peppol.sbdh;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import no.difi.vefa.peppol.common.model.Header;
import no.difi.vefa.peppol.common.util.ExceptionUtil;
import no.difi.vefa.peppol.sbdh.Ns;
import no.difi.vefa.peppol.sbdh.SbdhHelper;
import no.difi.vefa.peppol.sbdh.SbdhReader;
import no.difi.vefa.peppol.sbdh.lang.SbdhException;
import no.difi.vefa.peppol.sbdh.util.XMLStreamPartialReaderWrapper;
import no.difi.vefa.peppol.sbdh.util.XMLTextInputStream;
import org.apache.commons.codec.binary.Base64InputStream;

public class SbdReader
implements Closeable {
    private XMLStreamReader reader;
    private Header header;

    public static SbdReader newInstance(InputStream inputStream) throws SbdhException {
        return (SbdReader)ExceptionUtil.perform(SbdhException.class, () -> SbdReader.newInstance(SbdhHelper.XML_INPUT_FACTORY.createXMLStreamReader(inputStream)));
    }

    public static SbdReader newInstance(XMLStreamReader xmlStreamReader) throws SbdhException {
        return new SbdReader(xmlStreamReader);
    }

    private SbdReader(XMLStreamReader reader) throws SbdhException {
        this.reader = reader;
        try {
            if (reader.getEventType() != 1) {
                reader.nextTag();
            }
            if (!reader.getName().equals(Ns.QNAME_SBD)) {
                throw new SbdhException("Element 'StandardBusinessDocument' not found as first element.");
            }
            reader.nextTag();
            if (!reader.getName().equals(Ns.QNAME_SBDH)) {
                throw new SbdhException("Element 'StandardBusinessDocumentHeader' not found as first element in 'StandardBusinessDocument'.");
            }
            this.header = SbdhReader.read(reader);
            if (reader.getEventType() != 1) {
                reader.nextTag();
            }
            if (reader.getEventType() != 1) {
                throw new SbdhException("Payload not found.");
            }
        }
        catch (XMLStreamException e) {
            throw new SbdhException(e.getMessage(), e);
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public Type getType() {
        if (this.reader.getName().equals(Ns.QNAME_BINARY_CONTENT)) {
            return Type.BINARY;
        }
        if (this.reader.getName().equals(Ns.QNAME_TEXT_CONTENT)) {
            return Type.TEXT;
        }
        return Type.XML;
    }

    public XMLStreamReader xmlReader() {
        return new XMLStreamPartialReaderWrapper(this.reader);
    }

    public InputStream binaryReader() throws XMLStreamException {
        return new Base64InputStream((InputStream)new XMLTextInputStream(this.xmlReader()));
    }

    public InputStream textReader() throws XMLStreamException {
        return new XMLTextInputStream(this.xmlReader());
    }

    @Override
    public void close() throws IOException {
        ExceptionUtil.perform(IOException.class, this.reader::close);
    }

    public static enum Type {
        BINARY,
        TEXT,
        XML;

    }
}

