/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.http.client;

public final class DigipostHttpClientMillisecondTimeouts {
    public final int socket;
    public final int connect;
    public final int connectionRequest;

    DigipostHttpClientMillisecondTimeouts(int socket, int connect, int connectionRequest) {
        this.socket = this.zeroOrGreater(socket, "socket timeout");
        this.connect = this.zeroOrGreater(connect, "connect timeout");
        this.connectionRequest = this.zeroOrGreater(connectionRequest, "connection request timeout");
    }

    private int zeroOrGreater(int value, String nameOfValue) {
        if (value < 0) {
            throw new IllegalArgumentException(nameOfValue + " must be 0 or greater, but was " + value);
        }
        return value;
    }

    public DigipostHttpClientMillisecondTimeouts all(int timeoutMs) {
        return new DigipostHttpClientMillisecondTimeouts(timeoutMs, timeoutMs, timeoutMs);
    }

    public DigipostHttpClientMillisecondTimeouts socket(int timeoutMs) {
        return new DigipostHttpClientMillisecondTimeouts(timeoutMs, this.connect, this.connectionRequest);
    }

    public DigipostHttpClientMillisecondTimeouts connect(int timeoutMs) {
        return new DigipostHttpClientMillisecondTimeouts(this.socket, timeoutMs, this.connectionRequest);
    }

    public DigipostHttpClientMillisecondTimeouts connectionRequest(int timeoutMs) {
        return new DigipostHttpClientMillisecondTimeouts(this.socket, this.connect, timeoutMs);
    }

    boolean isPotentiallyDangerous() {
        return this.socket == 0 || this.connect == 0 || this.connectionRequest == 0;
    }
}

