/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.http.client;

import no.digipost.http.client.DigipostHttpClientDefaults;
import no.digipost.http.client.DigipostHttpClientFactory;
import no.digipost.http.client.DigipostHttpClientMillisecondTimeouts;
import org.apache.http.HttpHost;
import org.apache.http.config.ConnectionConfig;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class DigipostHttpClientSettings {
    public static final DigipostHttpClientSettings DEFAULT = new DigipostHttpClientSettings((Logger)NOPLogger.NOP_LOGGER, DigipostHttpClientFactory.createDefaultConnectionConfig(), DigipostHttpClientDefaults.CONNECTION_AMOUNT_NORMAL, null, DigipostHttpClientDefaults.DEFAULT_TIMEOUTS_MS);
    final HttpHost httpProxy;
    final Logger logger;
    final ConnectionConfig connectionConfig;
    final DigipostHttpClientDefaults.ConnectionAmount connectionAmount;
    final DigipostHttpClientMillisecondTimeouts timeoutsMs;

    public DigipostHttpClientSettings logConfigurationTo(Logger logger) {
        return new DigipostHttpClientSettings(logger, this.connectionConfig, this.connectionAmount, this.httpProxy, this.timeoutsMs);
    }

    public DigipostHttpClientSettings connections(DigipostHttpClientDefaults.ConnectionAmount connectionAmount) {
        return new DigipostHttpClientSettings(this.logger, this.connectionConfig, connectionAmount, this.httpProxy, this.timeoutsMs);
    }

    public DigipostHttpClientSettings useProxy(String proxyHostUrl) {
        return this.useProxy(HttpHost.create((String)proxyHostUrl));
    }

    public DigipostHttpClientSettings useProxy(HttpHost httpProxy) {
        return new DigipostHttpClientSettings(this.logger, this.connectionConfig, this.connectionAmount, httpProxy, this.timeoutsMs);
    }

    public DigipostHttpClientSettings timeouts(DigipostHttpClientMillisecondTimeouts timeoutsMs) {
        return new DigipostHttpClientSettings(this.logger, this.connectionConfig, this.connectionAmount, this.httpProxy, timeoutsMs);
    }

    public String toString() {
        return String.format(" - max total connections %s\n - max connections per route %s\n - so timeout %s ms\n - socket timeout %s ms\n - connect timeout %s ms\n - connection request timeout %s ms\n - proxy: %s", this.connectionAmount.maxTotal, this.connectionAmount.maxPerRoute, this.timeoutsMs.socket != 0 ? Integer.valueOf(this.timeoutsMs.socket) : "[infinite]", this.timeoutsMs.socket != 0 ? Integer.valueOf(this.timeoutsMs.socket) : "[infinite]", this.timeoutsMs.connect != 0 ? Integer.valueOf(this.timeoutsMs.connect) : "[infinite]", this.timeoutsMs.connectionRequest != 0 ? Integer.valueOf(this.timeoutsMs.connectionRequest) : "[infinite]", this.httpProxy != null ? this.httpProxy : "no configured proxy host");
    }

    private DigipostHttpClientSettings(Logger instantiationLogger, ConnectionConfig connectionConfig, DigipostHttpClientDefaults.ConnectionAmount connectionAmount, HttpHost proxy, DigipostHttpClientMillisecondTimeouts timeoutsMs) {
        this.logger = instantiationLogger;
        this.connectionConfig = connectionConfig;
        this.connectionAmount = connectionAmount;
        this.httpProxy = proxy;
        this.timeoutsMs = timeoutsMs;
    }
}

