/*
 * Decompiled with CFR 0.152.
 */
package no.entur.abt.netex.id;

import no.entur.abt.netex.id.NetexIdValidator;

public class DefaultNetexIdValidator
implements NetexIdValidator {
    public static final char NETEX_ID_SEPARATOR_CHAR = ':';
    public static final int NETEX_ID_CODESPACE_LENGTH = 3;
    public static final int NETEX_ID_MINIMUM_LENGTH = 6;
    protected static final DefaultNetexIdValidator instance = new DefaultNetexIdValidator();

    public static DefaultNetexIdValidator getInstance() {
        return instance;
    }

    @Override
    public boolean validate(CharSequence string, int offset, int length) {
        if (length < 6) {
            return false;
        }
        if (string.charAt(offset + 3) != ':') {
            return false;
        }
        int last = DefaultNetexIdValidator.getLastSeperatorIndex(string, 4, length);
        if (last == -1) {
            return false;
        }
        return this.validateCodespace(string, 0, 3) && this.validateType(string, 4, last) && this.validateValue(string, last + 1, string.length());
    }

    protected static int getLastSeperatorIndex(CharSequence string, int startIndex, int endIndex) {
        for (int i = endIndex - 1; i >= startIndex; --i) {
            if (string.charAt(i) != ':') continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean validateCodespace(CharSequence codespace, int startIndex, int endIndex) {
        if (endIndex - startIndex == 3) {
            for (int i = startIndex; i < endIndex; ++i) {
                char c = codespace.charAt(i);
                if (c >= 'A' && c <= 'Z') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validateType(CharSequence type, int startIndex, int endIndex) {
        if (endIndex > startIndex) {
            for (int i = startIndex; i < endIndex; ++i) {
                char c = type.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validateValue(CharSequence value, int startIndex, int endIndex) {
        if (endIndex > startIndex) {
            for (int i = startIndex; i < endIndex; ++i) {
                char c = value.charAt(i);
                if (DefaultNetexIdValidator.isValueCharacter(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static boolean isValueCharacter(char c) {
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case '-': 
            case '\\': 
            case '_': 
            case '\u00c5': 
            case '\u00c6': 
            case '\u00d8': 
            case '\u00e5': 
            case '\u00e6': 
            case '\u00f8': {
                return true;
            }
        }
        return false;
    }
}

