/*
 * Decompiled with CFR 0.152.
 */
package no.entur.abt.netex.id;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import no.entur.abt.netex.id.NetexIdParser;

public class InterningNetexIdParser
implements NetexIdParser {
    private final Map<String, String> intern = new HashMap<String, String>(1024);
    private final NetexIdParser delegate;

    public InterningNetexIdParser(NetexIdParser delegate, Collection<String> seed) {
        this.delegate = delegate;
        for (String string : seed) {
            String interned = string.intern();
            this.intern.put(interned, interned);
        }
    }

    public InterningNetexIdParser(NetexIdParser delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getCodespace(CharSequence id) {
        return this.intern(this.delegate.getCodespace(id));
    }

    @Override
    public String getType(CharSequence id) {
        return this.intern(this.delegate.getType(id));
    }

    @Override
    public String getValue(CharSequence id) {
        return this.delegate.getValue(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String intern(String codespace) {
        String interned = this.intern.get(codespace);
        if (interned == null) {
            Map<String, String> map = this.intern;
            synchronized (map) {
                interned = this.intern.get(codespace);
                if (interned == null) {
                    codespace = codespace.intern();
                    this.intern.put(codespace, codespace);
                    interned = codespace;
                }
            }
        }
        return interned;
    }
}

