/*
 * Decompiled with CFR 0.152.
 */
package no.entur.abt.netex.id;

import no.entur.abt.netex.id.DefaultNetexIdValidator;
import no.entur.abt.netex.id.NetexIdValidator;

public class NetexIdBuilder {
    protected static final String NETEX_ID_SEPARATOR_CHAR = ":";
    private static final NetexIdValidator defaultValidator = DefaultNetexIdValidator.getInstance();
    private final NetexIdValidator validator;
    protected String codespace;
    protected String type;
    protected String value;

    public static NetexIdBuilder newInstance() {
        return new NetexIdBuilder();
    }

    public NetexIdBuilder() {
        this(defaultValidator);
    }

    public NetexIdBuilder(NetexIdValidator validator) {
        this.validator = validator;
    }

    public NetexIdBuilder withCodespace(String codespace) {
        this.codespace = codespace;
        return this;
    }

    public NetexIdBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public NetexIdBuilder withValue(String value) {
        this.value = value;
        return this;
    }

    public String build() {
        if (this.codespace == null || !this.validator.validateCodespace(this.codespace)) {
            throw new IllegalStateException("Expected codespace (size 3 with characters A-Z), found " + this.codespace);
        }
        if (this.type == null || !this.validator.validateType(this.type)) {
            throw new IllegalStateException("Expected type (nonempty with characters A-Z), found " + this.type);
        }
        if (this.value == null || !this.validator.validateValue(this.value)) {
            throw new IllegalStateException("Expected value (nonempty with characters A-Z, a-z, \u00f8, \u00d8, \u00e6, \u00c6, \u00e5, \u00c5, underscore, \\ and -), found " + this.value);
        }
        return String.join((CharSequence)NETEX_ID_SEPARATOR_CHAR, this.codespace, this.type, this.value);
    }
}

