/*
 * Decompiled with CFR 0.152.
 */
package no.entur.abt.netex.id;

import java.util.Set;
import no.entur.abt.netex.id.InterningNetexIdParser;
import no.entur.abt.netex.id.NetexIdNonvalidatingParser;
import no.entur.abt.netex.id.NetexIdParser;
import no.entur.abt.netex.id.NetexIdValidatingParser;

public class NetexIdParserBuilder {
    private boolean validation = true;
    private boolean intern = false;
    private Set<String> internSeed;

    public NetexIdParserBuilder newInstance() {
        return new NetexIdParserBuilder();
    }

    public NetexIdParserBuilder withValidation(boolean validation) {
        this.validation = validation;
        return this;
    }

    public NetexIdParserBuilder withStringInterning(boolean intern) {
        this.intern = intern;
        return this;
    }

    public NetexIdParserBuilder withStringInterningInitialValues(Set<String> values) {
        this.internSeed = values;
        return this;
    }

    public NetexIdParser build() {
        NetexIdParser parser = this.validation ? new NetexIdValidatingParser() : new NetexIdNonvalidatingParser();
        if (this.intern) {
            parser = this.internSeed != null ? new InterningNetexIdParser(parser, this.internSeed) : new InterningNetexIdParser(parser);
        }
        return parser;
    }
}

