/*
 * Decompiled with CFR 0.152.
 */
package no.entur.abt.netex.id;

import no.entur.abt.netex.id.DefaultNetexIdValidator;
import no.entur.abt.netex.id.NetexIdParser;
import no.entur.abt.netex.utils.IllegalNetexIDException;

public class NetexIdValidatingParser
implements NetexIdParser {
    private final DefaultNetexIdValidator validator = DefaultNetexIdValidator.getInstance();

    @Override
    public String getCodespace(CharSequence id) {
        if (!this.validator.validate(id)) {
            throw new IllegalNetexIDException("Invalid id " + id);
        }
        CharSequence result = id.subSequence(0, 3);
        return result.toString();
    }

    @Override
    public String getType(CharSequence id) {
        if (!this.validator.validate(id)) {
            throw new IllegalNetexIDException("Invalid id " + id);
        }
        int last = DefaultNetexIdValidator.getLastSeperatorIndex(id, 4, id.length());
        return id.subSequence(4, last).toString();
    }

    @Override
    public String getValue(CharSequence id) {
        if (!this.validator.validate(id)) {
            throw new IllegalNetexIDException("Invalid id " + id);
        }
        int last = DefaultNetexIdValidator.getLastSeperatorIndex(id, 4, id.length());
        return id.subSequence(last + 1, id.length()).toString();
    }
}

