/*
 * Decompiled with CFR 0.152.
 */
package no.entur.abt.netex.id.predicate;

import no.entur.abt.netex.id.DefaultNetexIdValidator;
import no.entur.abt.netex.id.NetexIdValidator;
import no.entur.abt.netex.id.predicate.NetexIdCodespacePredicate;
import no.entur.abt.netex.id.predicate.NetexIdCodespaceTypePredicate;
import no.entur.abt.netex.id.predicate.NetexIdPredicate;
import no.entur.abt.netex.id.predicate.NetexIdTypePredicate;

public class NetexIdPredicateBuilder {
    private static final NetexIdValidator validator = DefaultNetexIdValidator.getInstance();
    protected String codespace;
    protected String type;

    public static NetexIdPredicateBuilder newInstance() {
        return new NetexIdPredicateBuilder();
    }

    public NetexIdPredicateBuilder withCodespace(String codespace) {
        this.codespace = codespace;
        return this;
    }

    public NetexIdPredicateBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public NetexIdPredicate build() {
        if (this.codespace != null && !validator.validateCodespace(this.codespace)) {
            throw new IllegalStateException("Expected codespace (size 3 with characters A-Z), found " + this.codespace);
        }
        if (this.type != null && !validator.validateType(this.type)) {
            throw new IllegalStateException("Expected type (nonempty with characters A-Z), found " + this.type);
        }
        if (this.codespace != null && this.type != null) {
            return new NetexIdCodespaceTypePredicate(this.codespace, this.type);
        }
        if (this.codespace != null) {
            return new NetexIdCodespacePredicate(this.codespace);
        }
        if (this.type != null) {
            return new NetexIdTypePredicate(this.type);
        }
        throw new IllegalStateException("Expected codespace and/or type");
    }
}

