/*
 * Decompiled with CFR 0.152.
 */
package no.entur.abt.netex.utils;

import java.util.Objects;
import no.entur.abt.netex.utils.IllegalNetexIDException;

public class NetexIdUtils {
    private static final String NETEX_ID_SEPARATOR_CHAR = ":";
    private static final String ID_PATTERN = "^([A-Z]{3}):([A-Za-z]+):([0-9\u00c6\u00d8\u00c5\u00e6\u00f8\u00e5A-Za-z_\\\\-]+)$";

    public static String createId(String codespace, String datatype, String value) {
        return String.join((CharSequence)NETEX_ID_SEPARATOR_CHAR, codespace, datatype, value);
    }

    public static String getCodespace(String id) {
        NetexIdUtils.assertValid(id);
        return NetexIdUtils.getField(id, 0);
    }

    public static String getType(String id) {
        NetexIdUtils.assertValid(id);
        return NetexIdUtils.getField(id, 1);
    }

    public static String getValue(String id) {
        NetexIdUtils.assertValid(id);
        return NetexIdUtils.getField(id, 2);
    }

    public static boolean isValid(String id) {
        return id != null && id.matches(ID_PATTERN);
    }

    public static void assertValidOfType(String id, String expectedType) {
        NetexIdUtils.assertValid(id);
        if (!Objects.equals(NetexIdUtils.getType(id), expectedType)) {
            throw new IllegalNetexIDException(String.format("Value '%s' is not of expected type '%s'", id, expectedType));
        }
    }

    public static void assertValid(String id) {
        if (!NetexIdUtils.isValid(id)) {
            throw new IllegalNetexIDException(String.format("Value '%s' is not a valid NeTEx id according to profile. ID should be in the format Codespace:Type:Val (ie XYZ:FareContract:1231)", id));
        }
    }

    private static String getField(String id, int index) {
        try {
            return id.split(NETEX_ID_SEPARATOR_CHAR)[index];
        }
        catch (Exception e) {
            throw new IllegalNetexIDException(String.format("Value '%s' is not a valid NeTEx id according to profile. ID should be in the format Codespace:Type:Val (ie XYZ:FareContract:1231)", id), e);
        }
    }

    public static String createFrom(String id, String valuePart) {
        return NetexIdUtils.createId(NetexIdUtils.getCodespace(id), NetexIdUtils.getType(id), valuePart);
    }
}

