/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.jgrape.tx.ejb;

import java.rmi.RemoteException;

import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

import no.g9.dataaccess.Session;
import no.g9.exception.G9BaseException;
import no.g9.jgrape.tx.TxCommand;
import no.g9.jgrape.tx.TxService;
import no.g9.jgrape.tx.TxSessionManager;
import no.g9.support.ClientContext;

/**
 * Session bean for executing commands in a separate transaction context.
 * 
 */

@Remote(TxService.class)
@Stateless(mappedName="TxService")
@EJB(name="txEJB", mappedName="txEJB")
public class TxBean extends TxSessionManager implements TxService {

    /** The current session context. */
    private SessionContext context;
    
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public TxCommand executeCommand(final ClientContext clientContext,
                                    final String databaseMappingName,
                                    final TxCommand command) {
        final Session session = getSession(clientContext.getDatabaseContext(), 
                                           databaseMappingName);
        try {
            runTx(session, clientContext, command);            
        }       
        catch (final Exception e) {
            throw new G9BaseException(e);
        }
        finally {
            resetSession(clientContext.getDatabaseContext(), databaseMappingName);
        }
        return command;
    }

    /**
     * EJB interface method.
     *
     * @param context Current session context
     */
    public void setSessionContext(final SessionContext context) 
          throws EJBException, RemoteException {
        this.context = context;
    }

}
