/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import java.util.List;
import java.util.stream.Collectors;
import no.finn.unleash.FeatureToggle;
import no.finn.unleash.UnleashException;
import no.finn.unleash.event.EventDispatcher;
import no.finn.unleash.event.UnleashReady;
import no.finn.unleash.repository.FeatureToggleResponse;
import no.finn.unleash.repository.ToggleBackupHandler;
import no.finn.unleash.repository.ToggleCollection;
import no.finn.unleash.repository.ToggleFetcher;
import no.finn.unleash.repository.ToggleRepository;
import no.finn.unleash.util.UnleashConfig;
import no.finn.unleash.util.UnleashScheduledExecutor;

public final class FeatureToggleRepository
implements ToggleRepository {
    private final ToggleBackupHandler toggleBackupHandler;
    private final ToggleFetcher toggleFetcher;
    private final EventDispatcher eventDispatcher;
    private ToggleCollection toggleCollection;
    private boolean ready;

    public FeatureToggleRepository(UnleashConfig unleashConfig, ToggleFetcher toggleFetcher, ToggleBackupHandler toggleBackupHandler) {
        this(unleashConfig, unleashConfig.getScheduledExecutor(), toggleFetcher, toggleBackupHandler);
    }

    @Deprecated
    public FeatureToggleRepository(UnleashConfig unleashConfig, UnleashScheduledExecutor executor, ToggleFetcher toggleFetcher, ToggleBackupHandler toggleBackupHandler) {
        this.toggleBackupHandler = toggleBackupHandler;
        this.toggleFetcher = toggleFetcher;
        this.eventDispatcher = new EventDispatcher(unleashConfig);
        this.toggleCollection = toggleBackupHandler.read();
        if (unleashConfig.isSynchronousFetchOnInitialisation()) {
            this.updateToggles().run();
        }
        executor.setInterval(this.updateToggles(), 0L, unleashConfig.getFetchTogglesInterval());
    }

    private Runnable updateToggles() {
        return () -> {
            try {
                FeatureToggleResponse response = this.toggleFetcher.fetchToggles();
                this.eventDispatcher.dispatch(response);
                if (response.getStatus() == FeatureToggleResponse.Status.CHANGED) {
                    this.toggleCollection = response.getToggleCollection();
                    this.toggleBackupHandler.write(response.getToggleCollection());
                }
                if (!this.ready) {
                    this.eventDispatcher.dispatch(new UnleashReady());
                    this.ready = true;
                }
            }
            catch (UnleashException e) {
                this.eventDispatcher.dispatch(e);
            }
        };
    }

    @Override
    public FeatureToggle getToggle(String name) {
        return this.toggleCollection.getToggle(name);
    }

    @Override
    public List<String> getFeatureNames() {
        return this.toggleCollection.getFeatures().stream().map(toggle -> toggle.getName()).collect(Collectors.toList());
    }
}

