/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import no.finn.unleash.lang.Nullable;
import no.finn.unleash.util.UnleashScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnleashScheduledExecutorImpl
implements UnleashScheduledExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(UnleashScheduledExecutorImpl.class);
    @Nullable
    private static UnleashScheduledExecutorImpl INSTANCE;
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final ExecutorService executorService;

    public UnleashScheduledExecutorImpl() {
        ThreadFactory threadFactory = runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName("unleash-api-executor");
            thread.setDaemon(true);
            return thread;
        };
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, threadFactory);
        this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
    }

    public static synchronized UnleashScheduledExecutorImpl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UnleashScheduledExecutorImpl();
        }
        return INSTANCE;
    }

    @Override
    @Nullable
    public ScheduledFuture setInterval(Runnable command, long initialDelaySec, long periodSec) {
        try {
            return this.scheduledThreadPoolExecutor.scheduleAtFixedRate(command, initialDelaySec, periodSec, TimeUnit.SECONDS);
        }
        catch (RejectedExecutionException ex) {
            LOG.error("Unleash background task crashed", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Future<Void> scheduleOnce(Runnable runnable) {
        return this.executorService.submit(runnable);
    }

    @Override
    public void shutdown() {
        this.scheduledThreadPoolExecutor.shutdown();
    }
}

