/*
 * Decompiled with CFR 0.152.
 */
package no.ks.fiks.svarut.forsendelse.slett.invoker.v2.auth;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Optional;
import java.util.function.Supplier;

public class HttpBearerAuth
implements RequestInterceptor {
    private final String scheme;
    private Supplier<String> tokenSupplier;

    public HttpBearerAuth(String scheme) {
        this.scheme = scheme;
    }

    public String getBearerToken() {
        return this.tokenSupplier.get();
    }

    public void setBearerToken(String bearerToken) {
        this.tokenSupplier = () -> bearerToken;
    }

    public void setBearerToken(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    public void apply(RequestTemplate template) {
        String bearerToken = Optional.ofNullable(this.tokenSupplier).map(Supplier::get).orElse(null);
        if (bearerToken == null) {
            return;
        }
        template.header("Authorization", new String[]{(String)(this.scheme != null ? HttpBearerAuth.upperCaseBearer(this.scheme) + " " : "") + bearerToken});
    }

    private static String upperCaseBearer(String scheme) {
        return "bearer".equalsIgnoreCase(scheme) ? "Bearer" : scheme;
    }
}

